/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeArtifactDetails;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeIdentifier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypePermissions;
import software.amazon.awssdk.services.codepipeline.model.ActionTypePropertiesCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionTypeDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionTypeDeclaration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::description)).setter(ActionTypeDeclaration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<ActionTypeExecutor> EXECUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executor").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::executor)).setter(ActionTypeDeclaration.setter(Builder::executor)).constructor(ActionTypeExecutor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executor").build()}).build();
    private static final SdkField<ActionTypeIdentifier> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("id").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::id)).setter(ActionTypeDeclaration.setter(Builder::id)).constructor(ActionTypeIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ActionTypeArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputArtifactDetails").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::inputArtifactDetails)).setter(ActionTypeDeclaration.setter(Builder::inputArtifactDetails)).constructor(ActionTypeArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build()}).build();
    private static final SdkField<ActionTypeArtifactDetails> OUTPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputArtifactDetails").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::outputArtifactDetails)).setter(ActionTypeDeclaration.setter(Builder::outputArtifactDetails)).constructor(ActionTypeArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifactDetails").build()}).build();
    private static final SdkField<ActionTypePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("permissions").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::permissions)).setter(ActionTypeDeclaration.setter(Builder::permissions)).constructor(ActionTypePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()}).build();
    private static final SdkField<List<ActionTypeProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("properties").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::properties)).setter(ActionTypeDeclaration.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionTypeProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ActionTypeUrls> URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("urls").getter(ActionTypeDeclaration.getter(ActionTypeDeclaration::urls)).setter(ActionTypeDeclaration.setter(Builder::urls)).constructor(ActionTypeUrls::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EXECUTOR_FIELD, ID_FIELD, INPUT_ARTIFACT_DETAILS_FIELD, OUTPUT_ARTIFACT_DETAILS_FIELD, PERMISSIONS_FIELD, PROPERTIES_FIELD, URLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionTypeDeclaration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final ActionTypeExecutor executor;
    private final ActionTypeIdentifier id;
    private final ActionTypeArtifactDetails inputArtifactDetails;
    private final ActionTypeArtifactDetails outputArtifactDetails;
    private final ActionTypePermissions permissions;
    private final List<ActionTypeProperty> properties;
    private final ActionTypeUrls urls;

    private ActionTypeDeclaration(BuilderImpl builder) {
        this.description = builder.description;
        this.executor = builder.executor;
        this.id = builder.id;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
        this.permissions = builder.permissions;
        this.properties = builder.properties;
        this.urls = builder.urls;
    }

    public final String description() {
        return this.description;
    }

    public final ActionTypeExecutor executor() {
        return this.executor;
    }

    public final ActionTypeIdentifier id() {
        return this.id;
    }

    public final ActionTypeArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public final ActionTypeArtifactDetails outputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public final ActionTypePermissions permissions() {
        return this.permissions;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<ActionTypeProperty> properties() {
        return this.properties;
    }

    public final ActionTypeUrls urls() {
        return this.urls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executor());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.urls());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeDeclaration)) {
            return false;
        }
        ActionTypeDeclaration other = (ActionTypeDeclaration)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.executor(), other.executor()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inputArtifactDetails(), other.inputArtifactDetails()) && Objects.equals(this.outputArtifactDetails(), other.outputArtifactDetails()) && Objects.equals(this.permissions(), other.permissions()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.urls(), other.urls());
    }

    public final String toString() {
        return ToString.builder((String)"ActionTypeDeclaration").add("Description", (Object)this.description()).add("Executor", (Object)this.executor()).add("Id", (Object)this.id()).add("InputArtifactDetails", (Object)this.inputArtifactDetails()).add("OutputArtifactDetails", (Object)this.outputArtifactDetails()).add("Permissions", (Object)this.permissions()).add("Properties", this.hasProperties() ? this.properties() : null).add("Urls", (Object)this.urls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "executor": {
                return Optional.ofNullable(clazz.cast(this.executor()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "inputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.inputArtifactDetails()));
            }
            case "outputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.outputArtifactDetails()));
            }
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("executor", EXECUTOR_FIELD);
        map.put("id", ID_FIELD);
        map.put("inputArtifactDetails", INPUT_ARTIFACT_DETAILS_FIELD);
        map.put("outputArtifactDetails", OUTPUT_ARTIFACT_DETAILS_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("urls", URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeDeclaration, T> g) {
        return obj -> g.apply((ActionTypeDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private ActionTypeExecutor executor;
        private ActionTypeIdentifier id;
        private ActionTypeArtifactDetails inputArtifactDetails;
        private ActionTypeArtifactDetails outputArtifactDetails;
        private ActionTypePermissions permissions;
        private List<ActionTypeProperty> properties = DefaultSdkAutoConstructList.getInstance();
        private ActionTypeUrls urls;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeDeclaration model) {
            this.description(model.description);
            this.executor(model.executor);
            this.id(model.id);
            this.inputArtifactDetails(model.inputArtifactDetails);
            this.outputArtifactDetails(model.outputArtifactDetails);
            this.permissions(model.permissions);
            this.properties(model.properties);
            this.urls(model.urls);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTypeExecutor.Builder getExecutor() {
            return this.executor != null ? this.executor.toBuilder() : null;
        }

        public final void setExecutor(ActionTypeExecutor.BuilderImpl executor) {
            this.executor = executor != null ? executor.build() : null;
        }

        @Override
        public final Builder executor(ActionTypeExecutor executor) {
            this.executor = executor;
            return this;
        }

        public final ActionTypeIdentifier.Builder getId() {
            return this.id != null ? this.id.toBuilder() : null;
        }

        public final void setId(ActionTypeIdentifier.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(ActionTypeIdentifier id) {
            this.id = id;
            return this;
        }

        public final ActionTypeArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ActionTypeArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ActionTypeArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final ActionTypeArtifactDetails.Builder getOutputArtifactDetails() {
            return this.outputArtifactDetails != null ? this.outputArtifactDetails.toBuilder() : null;
        }

        public final void setOutputArtifactDetails(ActionTypeArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ActionTypeArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final ActionTypePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(ActionTypePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(ActionTypePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final List<ActionTypeProperty.Builder> getProperties() {
            List<ActionTypeProperty.Builder> result = ActionTypePropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<ActionTypeProperty.BuilderImpl> properties) {
            this.properties = ActionTypePropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<ActionTypeProperty> properties) {
            this.properties = ActionTypePropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(ActionTypeProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<ActionTypeProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (ActionTypeProperty)((ActionTypeProperty.Builder)ActionTypeProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ActionTypeUrls.Builder getUrls() {
            return this.urls != null ? this.urls.toBuilder() : null;
        }

        public final void setUrls(ActionTypeUrls.BuilderImpl urls) {
            this.urls = urls != null ? urls.build() : null;
        }

        @Override
        public final Builder urls(ActionTypeUrls urls) {
            this.urls = urls;
            return this;
        }

        public ActionTypeDeclaration build() {
            return new ActionTypeDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionTypeDeclaration> {
        public Builder description(String var1);

        public Builder executor(ActionTypeExecutor var1);

        default public Builder executor(Consumer<ActionTypeExecutor.Builder> executor) {
            return this.executor((ActionTypeExecutor)((ActionTypeExecutor.Builder)ActionTypeExecutor.builder().applyMutation(executor)).build());
        }

        public Builder id(ActionTypeIdentifier var1);

        default public Builder id(Consumer<ActionTypeIdentifier.Builder> id) {
            return this.id((ActionTypeIdentifier)((ActionTypeIdentifier.Builder)ActionTypeIdentifier.builder().applyMutation(id)).build());
        }

        public Builder inputArtifactDetails(ActionTypeArtifactDetails var1);

        default public Builder inputArtifactDetails(Consumer<ActionTypeArtifactDetails.Builder> inputArtifactDetails) {
            return this.inputArtifactDetails((ActionTypeArtifactDetails)((ActionTypeArtifactDetails.Builder)ActionTypeArtifactDetails.builder().applyMutation(inputArtifactDetails)).build());
        }

        public Builder outputArtifactDetails(ActionTypeArtifactDetails var1);

        default public Builder outputArtifactDetails(Consumer<ActionTypeArtifactDetails.Builder> outputArtifactDetails) {
            return this.outputArtifactDetails((ActionTypeArtifactDetails)((ActionTypeArtifactDetails.Builder)ActionTypeArtifactDetails.builder().applyMutation(outputArtifactDetails)).build());
        }

        public Builder permissions(ActionTypePermissions var1);

        default public Builder permissions(Consumer<ActionTypePermissions.Builder> permissions) {
            return this.permissions((ActionTypePermissions)((ActionTypePermissions.Builder)ActionTypePermissions.builder().applyMutation(permissions)).build());
        }

        public Builder properties(Collection<ActionTypeProperty> var1);

        public Builder properties(ActionTypeProperty ... var1);

        public Builder properties(Consumer<ActionTypeProperty.Builder> ... var1);

        public Builder urls(ActionTypeUrls var1);

        default public Builder urls(Consumer<ActionTypeUrls.Builder> urls) {
            return this.urls((ActionTypeUrls)((ActionTypeUrls.Builder)ActionTypeUrls.builder().applyMutation(urls)).build());
        }
    }
}

