/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionInput;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionOutput;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleExecutionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleExecutionDetail> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionId").getter(RuleExecutionDetail.getter(RuleExecutionDetail::pipelineExecutionId)).setter(RuleExecutionDetail.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final SdkField<String> RULE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleExecutionId").getter(RuleExecutionDetail.getter(RuleExecutionDetail::ruleExecutionId)).setter(RuleExecutionDetail.setter(Builder::ruleExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionId").build()}).build();
    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pipelineVersion").getter(RuleExecutionDetail.getter(RuleExecutionDetail::pipelineVersion)).setter(RuleExecutionDetail.setter(Builder::pipelineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageName").getter(RuleExecutionDetail.getter(RuleExecutionDetail::stageName)).setter(RuleExecutionDetail.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(RuleExecutionDetail.getter(RuleExecutionDetail::ruleName)).setter(RuleExecutionDetail.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(RuleExecutionDetail.getter(RuleExecutionDetail::startTime)).setter(RuleExecutionDetail.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(RuleExecutionDetail.getter(RuleExecutionDetail::lastUpdateTime)).setter(RuleExecutionDetail.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(RuleExecutionDetail.getter(RuleExecutionDetail::updatedBy)).setter(RuleExecutionDetail.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RuleExecutionDetail.getter(RuleExecutionDetail::statusAsString)).setter(RuleExecutionDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<RuleExecutionInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("input").getter(RuleExecutionDetail.getter(RuleExecutionDetail::input)).setter(RuleExecutionDetail.setter(Builder::input)).constructor(RuleExecutionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<RuleExecutionOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("output").getter(RuleExecutionDetail.getter(RuleExecutionDetail::output)).setter(RuleExecutionDetail.setter(Builder::output)).constructor(RuleExecutionOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD, RULE_EXECUTION_ID_FIELD, PIPELINE_VERSION_FIELD, STAGE_NAME_FIELD, RULE_NAME_FIELD, START_TIME_FIELD, LAST_UPDATE_TIME_FIELD, UPDATED_BY_FIELD, STATUS_FIELD, INPUT_FIELD, OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleExecutionDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineExecutionId;
    private final String ruleExecutionId;
    private final Integer pipelineVersion;
    private final String stageName;
    private final String ruleName;
    private final Instant startTime;
    private final Instant lastUpdateTime;
    private final String updatedBy;
    private final String status;
    private final RuleExecutionInput input;
    private final RuleExecutionOutput output;

    private RuleExecutionDetail(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.ruleExecutionId = builder.ruleExecutionId;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageName = builder.stageName;
        this.ruleName = builder.ruleName;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.updatedBy = builder.updatedBy;
        this.status = builder.status;
        this.input = builder.input;
        this.output = builder.output;
    }

    public final String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public final String ruleExecutionId() {
        return this.ruleExecutionId;
    }

    public final Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final RuleExecutionStatus status() {
        return RuleExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RuleExecutionInput input() {
        return this.input;
    }

    public final RuleExecutionOutput output() {
        return this.output;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleExecutionDetail)) {
            return false;
        }
        RuleExecutionDetail other = (RuleExecutionDetail)obj;
        return Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.ruleExecutionId(), other.ruleExecutionId()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output());
    }

    public final String toString() {
        return ToString.builder((String)"RuleExecutionDetail").add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("RuleExecutionId", (Object)this.ruleExecutionId()).add("PipelineVersion", (Object)this.pipelineVersion()).add("StageName", (Object)this.stageName()).add("RuleName", (Object)this.ruleName()).add("StartTime", (Object)this.startTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("UpdatedBy", (Object)this.updatedBy()).add("Status", (Object)this.statusAsString()).add("Input", (Object)this.input()).add("Output", (Object)this.output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "ruleExecutionId": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionId()));
            }
            case "pipelineVersion": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersion()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineExecutionId", PIPELINE_EXECUTION_ID_FIELD);
        map.put("ruleExecutionId", RULE_EXECUTION_ID_FIELD);
        map.put("pipelineVersion", PIPELINE_VERSION_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("ruleName", RULE_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleExecutionDetail, T> g) {
        return obj -> g.apply((RuleExecutionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String ruleExecutionId;
        private Integer pipelineVersion;
        private String stageName;
        private String ruleName;
        private Instant startTime;
        private Instant lastUpdateTime;
        private String updatedBy;
        private String status;
        private RuleExecutionInput input;
        private RuleExecutionOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleExecutionDetail model) {
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.ruleExecutionId(model.ruleExecutionId);
            this.pipelineVersion(model.pipelineVersion);
            this.stageName(model.stageName);
            this.ruleName(model.ruleName);
            this.startTime(model.startTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.updatedBy(model.updatedBy);
            this.status(model.status);
            this.input(model.input);
            this.output(model.output);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getRuleExecutionId() {
            return this.ruleExecutionId;
        }

        public final void setRuleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
        }

        @Override
        public final Builder ruleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
            return this;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RuleExecutionInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(RuleExecutionInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(RuleExecutionInput input) {
            this.input = input;
            return this;
        }

        public final RuleExecutionOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(RuleExecutionOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(RuleExecutionOutput output) {
            this.output = output;
            return this;
        }

        public RuleExecutionDetail build() {
            return new RuleExecutionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleExecutionDetail> {
        public Builder pipelineExecutionId(String var1);

        public Builder ruleExecutionId(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder stageName(String var1);

        public Builder ruleName(String var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder updatedBy(String var1);

        public Builder status(String var1);

        public Builder status(RuleExecutionStatus var1);

        public Builder input(RuleExecutionInput var1);

        default public Builder input(Consumer<RuleExecutionInput.Builder> input) {
            return this.input((RuleExecutionInput)((RuleExecutionInput.Builder)RuleExecutionInput.builder().applyMutation(input)).build());
        }

        public Builder output(RuleExecutionOutput var1);

        default public Builder output(Consumer<RuleExecutionOutput.Builder> output) {
            return this.output((RuleExecutionOutput)((RuleExecutionOutput.Builder)RuleExecutionOutput.builder().applyMutation(output)).build());
        }
    }
}

