/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionDetails> {
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(ExecutionDetails.getter(ExecutionDetails::summary)).setter(ExecutionDetails.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalExecutionId").getter(ExecutionDetails.getter(ExecutionDetails::externalExecutionId)).setter(ExecutionDetails.setter(Builder::externalExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build()}).build();
    private static final SdkField<Integer> PERCENT_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("percentComplete").getter(ExecutionDetails.getter(ExecutionDetails::percentComplete)).setter(ExecutionDetails.setter(Builder::percentComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentComplete").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, EXTERNAL_EXECUTION_ID_FIELD, PERCENT_COMPLETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String summary;
    private final String externalExecutionId;
    private final Integer percentComplete;

    private ExecutionDetails(BuilderImpl builder) {
        this.summary = builder.summary;
        this.externalExecutionId = builder.externalExecutionId;
        this.percentComplete = builder.percentComplete;
    }

    public final String summary() {
        return this.summary;
    }

    public final String externalExecutionId() {
        return this.externalExecutionId;
    }

    public final Integer percentComplete() {
        return this.percentComplete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentComplete());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionDetails)) {
            return false;
        }
        ExecutionDetails other = (ExecutionDetails)obj;
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.externalExecutionId(), other.externalExecutionId()) && Objects.equals(this.percentComplete(), other.percentComplete());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionDetails").add("Summary", (Object)this.summary()).add("ExternalExecutionId", (Object)this.externalExecutionId()).add("PercentComplete", (Object)this.percentComplete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "externalExecutionId": {
                return Optional.ofNullable(clazz.cast(this.externalExecutionId()));
            }
            case "percentComplete": {
                return Optional.ofNullable(clazz.cast(this.percentComplete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("summary", SUMMARY_FIELD);
        map.put("externalExecutionId", EXTERNAL_EXECUTION_ID_FIELD);
        map.put("percentComplete", PERCENT_COMPLETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionDetails, T> g) {
        return obj -> g.apply((ExecutionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String summary;
        private String externalExecutionId;
        private Integer percentComplete;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionDetails model) {
            this.summary(model.summary);
            this.externalExecutionId(model.externalExecutionId);
            this.percentComplete(model.percentComplete);
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final Integer getPercentComplete() {
            return this.percentComplete;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        public ExecutionDetails build() {
            return new ExecutionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionDetails> {
        public Builder summary(String var1);

        public Builder externalExecutionId(String var1);

        public Builder percentComplete(Integer var1);
    }
}

