/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.RetryTrigger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryStageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryStageMetadata> {
    private static final SdkField<Integer> AUTO_STAGE_RETRY_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("autoStageRetryAttempt").getter(RetryStageMetadata.getter(RetryStageMetadata::autoStageRetryAttempt)).setter(RetryStageMetadata.setter(Builder::autoStageRetryAttempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStageRetryAttempt").build()}).build();
    private static final SdkField<Integer> MANUAL_STAGE_RETRY_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("manualStageRetryAttempt").getter(RetryStageMetadata.getter(RetryStageMetadata::manualStageRetryAttempt)).setter(RetryStageMetadata.setter(Builder::manualStageRetryAttempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualStageRetryAttempt").build()}).build();
    private static final SdkField<String> LATEST_RETRY_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestRetryTrigger").getter(RetryStageMetadata.getter(RetryStageMetadata::latestRetryTriggerAsString)).setter(RetryStageMetadata.setter(Builder::latestRetryTrigger)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRetryTrigger").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_STAGE_RETRY_ATTEMPT_FIELD, MANUAL_STAGE_RETRY_ATTEMPT_FIELD, LATEST_RETRY_TRIGGER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer autoStageRetryAttempt;
    private final Integer manualStageRetryAttempt;
    private final String latestRetryTrigger;

    private RetryStageMetadata(BuilderImpl builder) {
        this.autoStageRetryAttempt = builder.autoStageRetryAttempt;
        this.manualStageRetryAttempt = builder.manualStageRetryAttempt;
        this.latestRetryTrigger = builder.latestRetryTrigger;
    }

    public final Integer autoStageRetryAttempt() {
        return this.autoStageRetryAttempt;
    }

    public final Integer manualStageRetryAttempt() {
        return this.manualStageRetryAttempt;
    }

    public final RetryTrigger latestRetryTrigger() {
        return RetryTrigger.fromValue(this.latestRetryTrigger);
    }

    public final String latestRetryTriggerAsString() {
        return this.latestRetryTrigger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoStageRetryAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualStageRetryAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRetryTriggerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStageMetadata)) {
            return false;
        }
        RetryStageMetadata other = (RetryStageMetadata)obj;
        return Objects.equals(this.autoStageRetryAttempt(), other.autoStageRetryAttempt()) && Objects.equals(this.manualStageRetryAttempt(), other.manualStageRetryAttempt()) && Objects.equals(this.latestRetryTriggerAsString(), other.latestRetryTriggerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetryStageMetadata").add("AutoStageRetryAttempt", (Object)this.autoStageRetryAttempt()).add("ManualStageRetryAttempt", (Object)this.manualStageRetryAttempt()).add("LatestRetryTrigger", (Object)this.latestRetryTriggerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoStageRetryAttempt": {
                return Optional.ofNullable(clazz.cast(this.autoStageRetryAttempt()));
            }
            case "manualStageRetryAttempt": {
                return Optional.ofNullable(clazz.cast(this.manualStageRetryAttempt()));
            }
            case "latestRetryTrigger": {
                return Optional.ofNullable(clazz.cast(this.latestRetryTriggerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryStageMetadata, T> g) {
        return obj -> g.apply((RetryStageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer autoStageRetryAttempt;
        private Integer manualStageRetryAttempt;
        private String latestRetryTrigger;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStageMetadata model) {
            this.autoStageRetryAttempt(model.autoStageRetryAttempt);
            this.manualStageRetryAttempt(model.manualStageRetryAttempt);
            this.latestRetryTrigger(model.latestRetryTrigger);
        }

        public final Integer getAutoStageRetryAttempt() {
            return this.autoStageRetryAttempt;
        }

        public final void setAutoStageRetryAttempt(Integer autoStageRetryAttempt) {
            this.autoStageRetryAttempt = autoStageRetryAttempt;
        }

        @Override
        public final Builder autoStageRetryAttempt(Integer autoStageRetryAttempt) {
            this.autoStageRetryAttempt = autoStageRetryAttempt;
            return this;
        }

        public final Integer getManualStageRetryAttempt() {
            return this.manualStageRetryAttempt;
        }

        public final void setManualStageRetryAttempt(Integer manualStageRetryAttempt) {
            this.manualStageRetryAttempt = manualStageRetryAttempt;
        }

        @Override
        public final Builder manualStageRetryAttempt(Integer manualStageRetryAttempt) {
            this.manualStageRetryAttempt = manualStageRetryAttempt;
            return this;
        }

        public final String getLatestRetryTrigger() {
            return this.latestRetryTrigger;
        }

        public final void setLatestRetryTrigger(String latestRetryTrigger) {
            this.latestRetryTrigger = latestRetryTrigger;
        }

        @Override
        public final Builder latestRetryTrigger(String latestRetryTrigger) {
            this.latestRetryTrigger = latestRetryTrigger;
            return this;
        }

        @Override
        public final Builder latestRetryTrigger(RetryTrigger latestRetryTrigger) {
            this.latestRetryTrigger(latestRetryTrigger == null ? null : latestRetryTrigger.toString());
            return this;
        }

        public RetryStageMetadata build() {
            return new RetryStageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryStageMetadata> {
        public Builder autoStageRetryAttempt(Integer var1);

        public Builder manualStageRetryAttempt(Integer var1);

        public Builder latestRetryTrigger(String var1);

        public Builder latestRetryTrigger(RetryTrigger var1);
    }
}

