/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionDeclaration;
import software.amazon.awssdk.services.codepipeline.model.BeforeEntryConditions;
import software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration;
import software.amazon.awssdk.services.codepipeline.model.FailureConditions;
import software.amazon.awssdk.services.codepipeline.model.StageActionDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageBlockerDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.SuccessConditions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StageDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StageDeclaration.getter(StageDeclaration::name)).setter(StageDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<BlockerDeclaration>> BLOCKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockers").getter(StageDeclaration.getter(StageDeclaration::blockers)).setter(StageDeclaration.setter(Builder::blockers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockerDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ActionDeclaration>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(StageDeclaration.getter(StageDeclaration::actions)).setter(StageDeclaration.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FailureConditions> ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onFailure").getter(StageDeclaration.getter(StageDeclaration::onFailure)).setter(StageDeclaration.setter(Builder::onFailure)).constructor(FailureConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailure").build()}).build();
    private static final SdkField<SuccessConditions> ON_SUCCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onSuccess").getter(StageDeclaration.getter(StageDeclaration::onSuccess)).setter(StageDeclaration.setter(Builder::onSuccess)).constructor(SuccessConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onSuccess").build()}).build();
    private static final SdkField<BeforeEntryConditions> BEFORE_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("beforeEntry").getter(StageDeclaration.getter(StageDeclaration::beforeEntry)).setter(StageDeclaration.setter(Builder::beforeEntry)).constructor(BeforeEntryConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeEntry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BLOCKERS_FIELD, ACTIONS_FIELD, ON_FAILURE_FIELD, ON_SUCCESS_FIELD, BEFORE_ENTRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<BlockerDeclaration> blockers;
    private final List<ActionDeclaration> actions;
    private final FailureConditions onFailure;
    private final SuccessConditions onSuccess;
    private final BeforeEntryConditions beforeEntry;

    private StageDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.blockers = builder.blockers;
        this.actions = builder.actions;
        this.onFailure = builder.onFailure;
        this.onSuccess = builder.onSuccess;
        this.beforeEntry = builder.beforeEntry;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasBlockers() {
        return this.blockers != null && !(this.blockers instanceof SdkAutoConstructList);
    }

    public final List<BlockerDeclaration> blockers() {
        return this.blockers;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<ActionDeclaration> actions() {
        return this.actions;
    }

    public final FailureConditions onFailure() {
        return this.onFailure;
    }

    public final SuccessConditions onSuccess() {
        return this.onSuccess;
    }

    public final BeforeEntryConditions beforeEntry() {
        return this.beforeEntry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockers() ? this.blockers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.onFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.onSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeEntry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeclaration)) {
            return false;
        }
        StageDeclaration other = (StageDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && this.hasBlockers() == other.hasBlockers() && Objects.equals(this.blockers(), other.blockers()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.onFailure(), other.onFailure()) && Objects.equals(this.onSuccess(), other.onSuccess()) && Objects.equals(this.beforeEntry(), other.beforeEntry());
    }

    public final String toString() {
        return ToString.builder((String)"StageDeclaration").add("Name", (Object)this.name()).add("Blockers", this.hasBlockers() ? this.blockers() : null).add("Actions", this.hasActions() ? this.actions() : null).add("OnFailure", (Object)this.onFailure()).add("OnSuccess", (Object)this.onSuccess()).add("BeforeEntry", (Object)this.beforeEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "blockers": {
                return Optional.ofNullable(clazz.cast(this.blockers()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "onFailure": {
                return Optional.ofNullable(clazz.cast(this.onFailure()));
            }
            case "onSuccess": {
                return Optional.ofNullable(clazz.cast(this.onSuccess()));
            }
            case "beforeEntry": {
                return Optional.ofNullable(clazz.cast(this.beforeEntry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageDeclaration, T> g) {
        return obj -> g.apply((StageDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<BlockerDeclaration> blockers = DefaultSdkAutoConstructList.getInstance();
        private List<ActionDeclaration> actions = DefaultSdkAutoConstructList.getInstance();
        private FailureConditions onFailure;
        private SuccessConditions onSuccess;
        private BeforeEntryConditions beforeEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeclaration model) {
            this.name(model.name);
            this.blockers(model.blockers);
            this.actions(model.actions);
            this.onFailure(model.onFailure);
            this.onSuccess(model.onSuccess);
            this.beforeEntry(model.beforeEntry);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<BlockerDeclaration.Builder> getBlockers() {
            List<BlockerDeclaration.Builder> result = StageBlockerDeclarationListCopier.copyToBuilder(this.blockers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockers(Collection<BlockerDeclaration.BuilderImpl> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copyFromBuilder(blockers);
        }

        @Override
        public final Builder blockers(Collection<BlockerDeclaration> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copy(blockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(BlockerDeclaration ... blockers) {
            this.blockers(Arrays.asList(blockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(Consumer<BlockerDeclaration.Builder> ... blockers) {
            this.blockers(Stream.of(blockers).map(c -> (BlockerDeclaration)((BlockerDeclaration.Builder)BlockerDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ActionDeclaration.Builder> getActions() {
            List<ActionDeclaration.Builder> result = StageActionDeclarationListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ActionDeclaration.BuilderImpl> actions) {
            this.actions = StageActionDeclarationListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ActionDeclaration> actions) {
            this.actions = StageActionDeclarationListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionDeclaration ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ActionDeclaration.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (ActionDeclaration)((ActionDeclaration.Builder)ActionDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FailureConditions.Builder getOnFailure() {
            return this.onFailure != null ? this.onFailure.toBuilder() : null;
        }

        public final void setOnFailure(FailureConditions.BuilderImpl onFailure) {
            this.onFailure = onFailure != null ? onFailure.build() : null;
        }

        @Override
        public final Builder onFailure(FailureConditions onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public final SuccessConditions.Builder getOnSuccess() {
            return this.onSuccess != null ? this.onSuccess.toBuilder() : null;
        }

        public final void setOnSuccess(SuccessConditions.BuilderImpl onSuccess) {
            this.onSuccess = onSuccess != null ? onSuccess.build() : null;
        }

        @Override
        public final Builder onSuccess(SuccessConditions onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public final BeforeEntryConditions.Builder getBeforeEntry() {
            return this.beforeEntry != null ? this.beforeEntry.toBuilder() : null;
        }

        public final void setBeforeEntry(BeforeEntryConditions.BuilderImpl beforeEntry) {
            this.beforeEntry = beforeEntry != null ? beforeEntry.build() : null;
        }

        @Override
        public final Builder beforeEntry(BeforeEntryConditions beforeEntry) {
            this.beforeEntry = beforeEntry;
            return this;
        }

        public StageDeclaration build() {
            return new StageDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StageDeclaration> {
        public Builder name(String var1);

        public Builder blockers(Collection<BlockerDeclaration> var1);

        public Builder blockers(BlockerDeclaration ... var1);

        public Builder blockers(Consumer<BlockerDeclaration.Builder> ... var1);

        public Builder actions(Collection<ActionDeclaration> var1);

        public Builder actions(ActionDeclaration ... var1);

        public Builder actions(Consumer<ActionDeclaration.Builder> ... var1);

        public Builder onFailure(FailureConditions var1);

        default public Builder onFailure(Consumer<FailureConditions.Builder> onFailure) {
            return this.onFailure((FailureConditions)((FailureConditions.Builder)FailureConditions.builder().applyMutation(onFailure)).build());
        }

        public Builder onSuccess(SuccessConditions var1);

        default public Builder onSuccess(Consumer<SuccessConditions.Builder> onSuccess) {
            return this.onSuccess((SuccessConditions)((SuccessConditions.Builder)SuccessConditions.builder().applyMutation(onSuccess)).build());
        }

        public Builder beforeEntry(BeforeEntryConditions var1);

        default public Builder beforeEntry(Consumer<BeforeEntryConditions.Builder> beforeEntry) {
            return this.beforeEntry((BeforeEntryConditions)((BeforeEntryConditions.Builder)BeforeEntryConditions.builder().applyMutation(beforeEntry)).build());
        }
    }
}

