/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevision;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevisionListCopier;
import software.amazon.awssdk.services.codepipeline.model.ExecutionMode;
import software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger;
import software.amazon.awssdk.services.codepipeline.model.ExecutionType;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata;
import software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariable;
import software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecution> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(PipelineExecution.getter(PipelineExecution::pipelineName)).setter(PipelineExecution.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pipelineVersion").getter(PipelineExecution.getter(PipelineExecution::pipelineVersion)).setter(PipelineExecution.setter(Builder::pipelineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionId").getter(PipelineExecution.getter(PipelineExecution::pipelineExecutionId)).setter(PipelineExecution.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PipelineExecution.getter(PipelineExecution::statusAsString)).setter(PipelineExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusSummary").getter(PipelineExecution.getter(PipelineExecution::statusSummary)).setter(PipelineExecution.setter(Builder::statusSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<List<ArtifactRevision>> ARTIFACT_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("artifactRevisions").getter(PipelineExecution.getter(PipelineExecution::artifactRevisions)).setter(PipelineExecution.setter(Builder::artifactRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResolvedPipelineVariable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(PipelineExecution.getter(PipelineExecution::variables)).setter(PipelineExecution.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolvedPipelineVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExecutionTrigger> TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trigger").getter(PipelineExecution.getter(PipelineExecution::trigger)).setter(PipelineExecution.setter(Builder::trigger)).constructor(ExecutionTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trigger").build()}).build();
    private static final SdkField<String> EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionMode").getter(PipelineExecution.getter(PipelineExecution::executionModeAsString)).setter(PipelineExecution.setter(Builder::executionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionMode").build()}).build();
    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionType").getter(PipelineExecution.getter(PipelineExecution::executionTypeAsString)).setter(PipelineExecution.setter(Builder::executionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionType").build()}).build();
    private static final SdkField<PipelineRollbackMetadata> ROLLBACK_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rollbackMetadata").getter(PipelineExecution.getter(PipelineExecution::rollbackMetadata)).setter(PipelineExecution.setter(Builder::rollbackMetadata)).constructor(PipelineRollbackMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_VERSION_FIELD, PIPELINE_EXECUTION_ID_FIELD, STATUS_FIELD, STATUS_SUMMARY_FIELD, ARTIFACT_REVISIONS_FIELD, VARIABLES_FIELD, TRIGGER_FIELD, EXECUTION_MODE_FIELD, EXECUTION_TYPE_FIELD, ROLLBACK_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineName;
    private final Integer pipelineVersion;
    private final String pipelineExecutionId;
    private final String status;
    private final String statusSummary;
    private final List<ArtifactRevision> artifactRevisions;
    private final List<ResolvedPipelineVariable> variables;
    private final ExecutionTrigger trigger;
    private final String executionMode;
    private final String executionType;
    private final PipelineRollbackMetadata rollbackMetadata;

    private PipelineExecution(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.statusSummary = builder.statusSummary;
        this.artifactRevisions = builder.artifactRevisions;
        this.variables = builder.variables;
        this.trigger = builder.trigger;
        this.executionMode = builder.executionMode;
        this.executionType = builder.executionType;
        this.rollbackMetadata = builder.rollbackMetadata;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public final String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public final PipelineExecutionStatus status() {
        return PipelineExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusSummary() {
        return this.statusSummary;
    }

    public final boolean hasArtifactRevisions() {
        return this.artifactRevisions != null && !(this.artifactRevisions instanceof SdkAutoConstructList);
    }

    public final List<ArtifactRevision> artifactRevisions() {
        return this.artifactRevisions;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<ResolvedPipelineVariable> variables() {
        return this.variables;
    }

    public final ExecutionTrigger trigger() {
        return this.trigger;
    }

    public final ExecutionMode executionMode() {
        return ExecutionMode.fromValue(this.executionMode);
    }

    public final String executionModeAsString() {
        return this.executionMode;
    }

    public final ExecutionType executionType() {
        return ExecutionType.fromValue(this.executionType);
    }

    public final String executionTypeAsString() {
        return this.executionType;
    }

    public final PipelineRollbackMetadata rollbackMetadata() {
        return this.rollbackMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactRevisions() ? this.artifactRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusSummary(), other.statusSummary()) && this.hasArtifactRevisions() == other.hasArtifactRevisions() && Objects.equals(this.artifactRevisions(), other.artifactRevisions()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.trigger(), other.trigger()) && Objects.equals(this.executionModeAsString(), other.executionModeAsString()) && Objects.equals(this.executionTypeAsString(), other.executionTypeAsString()) && Objects.equals(this.rollbackMetadata(), other.rollbackMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineExecution").add("PipelineName", (Object)this.pipelineName()).add("PipelineVersion", (Object)this.pipelineVersion()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("Status", (Object)this.statusAsString()).add("StatusSummary", (Object)this.statusSummary()).add("ArtifactRevisions", this.hasArtifactRevisions() ? this.artifactRevisions() : null).add("Variables", this.hasVariables() ? this.variables() : null).add("Trigger", (Object)this.trigger()).add("ExecutionMode", (Object)this.executionModeAsString()).add("ExecutionType", (Object)this.executionTypeAsString()).add("RollbackMetadata", (Object)this.rollbackMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineVersion": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersion()));
            }
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "artifactRevisions": {
                return Optional.ofNullable(clazz.cast(this.artifactRevisions()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "trigger": {
                return Optional.ofNullable(clazz.cast(this.trigger()));
            }
            case "executionMode": {
                return Optional.ofNullable(clazz.cast(this.executionModeAsString()));
            }
            case "executionType": {
                return Optional.ofNullable(clazz.cast(this.executionTypeAsString()));
            }
            case "rollbackMetadata": {
                return Optional.ofNullable(clazz.cast(this.rollbackMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecution, T> g) {
        return obj -> g.apply((PipelineExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer pipelineVersion;
        private String pipelineExecutionId;
        private String status;
        private String statusSummary;
        private List<ArtifactRevision> artifactRevisions = DefaultSdkAutoConstructList.getInstance();
        private List<ResolvedPipelineVariable> variables = DefaultSdkAutoConstructList.getInstance();
        private ExecutionTrigger trigger;
        private String executionMode;
        private String executionType;
        private PipelineRollbackMetadata rollbackMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecution model) {
            this.pipelineName(model.pipelineName);
            this.pipelineVersion(model.pipelineVersion);
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.status(model.status);
            this.statusSummary(model.statusSummary);
            this.artifactRevisions(model.artifactRevisions);
            this.variables(model.variables);
            this.trigger(model.trigger);
            this.executionMode(model.executionMode);
            this.executionType(model.executionType);
            this.rollbackMetadata(model.rollbackMetadata);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusSummary() {
            return this.statusSummary;
        }

        public final void setStatusSummary(String statusSummary) {
            this.statusSummary = statusSummary;
        }

        @Override
        public final Builder statusSummary(String statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final List<ArtifactRevision.Builder> getArtifactRevisions() {
            List<ArtifactRevision.Builder> result = ArtifactRevisionListCopier.copyToBuilder(this.artifactRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifactRevisions(Collection<ArtifactRevision.BuilderImpl> artifactRevisions) {
            this.artifactRevisions = ArtifactRevisionListCopier.copyFromBuilder(artifactRevisions);
        }

        @Override
        public final Builder artifactRevisions(Collection<ArtifactRevision> artifactRevisions) {
            this.artifactRevisions = ArtifactRevisionListCopier.copy(artifactRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactRevisions(ArtifactRevision ... artifactRevisions) {
            this.artifactRevisions(Arrays.asList(artifactRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactRevisions(Consumer<ArtifactRevision.Builder> ... artifactRevisions) {
            this.artifactRevisions(Stream.of(artifactRevisions).map(c -> (ArtifactRevision)((ArtifactRevision.Builder)ArtifactRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResolvedPipelineVariable.Builder> getVariables() {
            List<ResolvedPipelineVariable.Builder> result = ResolvedPipelineVariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<ResolvedPipelineVariable.BuilderImpl> variables) {
            this.variables = ResolvedPipelineVariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<ResolvedPipelineVariable> variables) {
            this.variables = ResolvedPipelineVariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(ResolvedPipelineVariable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<ResolvedPipelineVariable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (ResolvedPipelineVariable)((ResolvedPipelineVariable.Builder)ResolvedPipelineVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ExecutionTrigger.Builder getTrigger() {
            return this.trigger != null ? this.trigger.toBuilder() : null;
        }

        public final void setTrigger(ExecutionTrigger.BuilderImpl trigger) {
            this.trigger = trigger != null ? trigger.build() : null;
        }

        @Override
        public final Builder trigger(ExecutionTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public final String getExecutionMode() {
            return this.executionMode;
        }

        public final void setExecutionMode(String executionMode) {
            this.executionMode = executionMode;
        }

        @Override
        public final Builder executionMode(String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Override
        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode(executionMode == null ? null : executionMode.toString());
            return this;
        }

        public final String getExecutionType() {
            return this.executionType;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        @Override
        public final Builder executionType(ExecutionType executionType) {
            this.executionType(executionType == null ? null : executionType.toString());
            return this;
        }

        public final PipelineRollbackMetadata.Builder getRollbackMetadata() {
            return this.rollbackMetadata != null ? this.rollbackMetadata.toBuilder() : null;
        }

        public final void setRollbackMetadata(PipelineRollbackMetadata.BuilderImpl rollbackMetadata) {
            this.rollbackMetadata = rollbackMetadata != null ? rollbackMetadata.build() : null;
        }

        @Override
        public final Builder rollbackMetadata(PipelineRollbackMetadata rollbackMetadata) {
            this.rollbackMetadata = rollbackMetadata;
            return this;
        }

        public PipelineExecution build() {
            return new PipelineExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecution> {
        public Builder pipelineName(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder statusSummary(String var1);

        public Builder artifactRevisions(Collection<ArtifactRevision> var1);

        public Builder artifactRevisions(ArtifactRevision ... var1);

        public Builder artifactRevisions(Consumer<ArtifactRevision.Builder> ... var1);

        public Builder variables(Collection<ResolvedPipelineVariable> var1);

        public Builder variables(ResolvedPipelineVariable ... var1);

        public Builder variables(Consumer<ResolvedPipelineVariable.Builder> ... var1);

        public Builder trigger(ExecutionTrigger var1);

        default public Builder trigger(Consumer<ExecutionTrigger.Builder> trigger) {
            return this.trigger((ExecutionTrigger)((ExecutionTrigger.Builder)ExecutionTrigger.builder().applyMutation(trigger)).build());
        }

        public Builder executionMode(String var1);

        public Builder executionMode(ExecutionMode var1);

        public Builder executionType(String var1);

        public Builder executionType(ExecutionType var1);

        public Builder rollbackMetadata(PipelineRollbackMetadata var1);

        default public Builder rollbackMetadata(Consumer<PipelineRollbackMetadata.Builder> rollbackMetadata) {
            return this.rollbackMetadata((PipelineRollbackMetadata)((PipelineRollbackMetadata.Builder)PipelineRollbackMetadata.builder().applyMutation(rollbackMetadata)).build());
        }
    }
}

