/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceRevisionType {
    COMMIT_ID("COMMIT_ID"),
    IMAGE_DIGEST("IMAGE_DIGEST"),
    S3_OBJECT_VERSION_ID("S3_OBJECT_VERSION_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceRevisionType> VALUE_MAP;
    private final String value;

    private SourceRevisionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceRevisionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceRevisionType> knownValues() {
        EnumSet<SourceRevisionType> knownValues = EnumSet.allOf(SourceRevisionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceRevisionType.class, SourceRevisionType::toString);
    }
}

