/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionExecutionStatus {
    IN_PROGRESS("InProgress"),
    ABANDONED("Abandoned"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionExecutionStatus> VALUE_MAP;
    private final String value;

    private ActionExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionExecutionStatus> knownValues() {
        EnumSet<ActionExecutionStatus> knownValues = EnumSet.allOf(ActionExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionExecutionStatus.class, ActionExecutionStatus::toString);
    }
}

