/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary;

public class ListPipelineExecutionsIterable
implements SdkIterable<ListPipelineExecutionsResponse> {
    private final CodePipelineClient client;
    private final ListPipelineExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelineExecutionsIterable(CodePipelineClient client, ListPipelineExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipelineExecutionsResponseFetcher();
    }

    public Iterator<ListPipelineExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineExecutionSummary> pipelineExecutionSummaries() {
        Function<ListPipelineExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineExecutionSummaries() != null) {
                return response.pipelineExecutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelineExecutionsResponseFetcher
    implements SyncPageFetcher<ListPipelineExecutionsResponse> {
        private ListPipelineExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelineExecutionsResponse nextPage(ListPipelineExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineExecutionsIterable.this.client.listPipelineExecutions(ListPipelineExecutionsIterable.this.firstRequest);
            }
            return ListPipelineExecutionsIterable.this.client.listPipelineExecutions((ListPipelineExecutionsRequest)((Object)ListPipelineExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

