/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionContext;
import software.amazon.awssdk.services.codepipeline.model.StageContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineContext> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(PipelineContext.getter(PipelineContext::pipelineName)).setter(PipelineContext.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<StageContext> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stage").getter(PipelineContext.getter(PipelineContext::stage)).setter(PipelineContext.setter(Builder::stage)).constructor(StageContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<ActionContext> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(PipelineContext.getter(PipelineContext::action)).setter(PipelineContext.setter(Builder::action)).constructor(ActionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineArn").getter(PipelineContext.getter(PipelineContext::pipelineArn)).setter(PipelineContext.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineArn").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionId").getter(PipelineContext.getter(PipelineContext::pipelineExecutionId)).setter(PipelineContext.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, STAGE_FIELD, ACTION_FIELD, PIPELINE_ARN_FIELD, PIPELINE_EXECUTION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineName;
    private final StageContext stage;
    private final ActionContext action;
    private final String pipelineArn;
    private final String pipelineExecutionId;

    private PipelineContext(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stage = builder.stage;
        this.action = builder.action;
        this.pipelineArn = builder.pipelineArn;
        this.pipelineExecutionId = builder.pipelineExecutionId;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final StageContext stage() {
        return this.stage;
    }

    public final ActionContext action() {
        return this.action;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineContext)) {
            return false;
        }
        PipelineContext other = (PipelineContext)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stage(), other.stage()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineContext").add("PipelineName", (Object)this.pipelineName()).add("Stage", (Object)this.stage()).add("Action", (Object)this.action()).add("PipelineArn", (Object)this.pipelineArn()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "pipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineContext, T> g) {
        return obj -> g.apply((PipelineContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private StageContext stage;
        private ActionContext action;
        private String pipelineArn;
        private String pipelineExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineContext model) {
            this.pipelineName(model.pipelineName);
            this.stage(model.stage);
            this.action(model.action);
            this.pipelineArn(model.pipelineArn);
            this.pipelineExecutionId(model.pipelineExecutionId);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final StageContext.Builder getStage() {
            return this.stage != null ? this.stage.toBuilder() : null;
        }

        public final void setStage(StageContext.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        @Override
        public final Builder stage(StageContext stage) {
            this.stage = stage;
            return this;
        }

        public final ActionContext.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(ActionContext.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ActionContext action) {
            this.action = action;
            return this;
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public PipelineContext build() {
            return new PipelineContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineContext> {
        public Builder pipelineName(String var1);

        public Builder stage(StageContext var1);

        default public Builder stage(Consumer<StageContext.Builder> stage) {
            return this.stage((StageContext)((StageContext.Builder)StageContext.builder().applyMutation(stage)).build());
        }

        public Builder action(ActionContext var1);

        default public Builder action(Consumer<ActionContext.Builder> action) {
            return this.action((ActionContext)((ActionContext.Builder)ActionContext.builder().applyMutation(action)).build());
        }

        public Builder pipelineArn(String var1);

        public Builder pipelineExecutionId(String var1);
    }
}

