/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PipelineSummary.getter(PipelineSummary::name)).setter(PipelineSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("version").getter(PipelineSummary.getter(PipelineSummary::version)).setter(PipelineSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(PipelineSummary.getter(PipelineSummary::created)).setter(PipelineSummary.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updated").getter(PipelineSummary.getter(PipelineSummary::updated)).setter(PipelineSummary.setter(Builder::updated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, CREATED_FIELD, UPDATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer version;
    private final Instant created;
    private final Instant updated;

    private PipelineSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public final String name() {
        return this.name;
    }

    public final Integer version() {
        return this.version;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.updated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.updated(), other.updated());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineSummary").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Created", (Object)this.created()).add("Updated", (Object)this.updated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "updated": {
                return Optional.ofNullable(clazz.cast(this.updated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer version;
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            this.name(model.name);
            this.version(model.version);
            this.created(model.created);
            this.updated(model.updated);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        @Override
        @Transient
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineSummary> {
        public Builder name(String var1);

        public Builder version(Integer var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

