/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ArtifactLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Artifact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Artifact> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Artifact.getter(Artifact::name)).setter(Artifact.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(Artifact.getter(Artifact::revision)).setter(Artifact.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<ArtifactLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Artifact.getter(Artifact::location)).setter(Artifact.setter(Builder::location)).constructor(ArtifactLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REVISION_FIELD, LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String revision;
    private final ArtifactLocation location;

    private Artifact(BuilderImpl builder) {
        this.name = builder.name;
        this.revision = builder.revision;
        this.location = builder.location;
    }

    public final String name() {
        return this.name;
    }

    public final String revision() {
        return this.revision;
    }

    public final ArtifactLocation location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"Artifact").add("Name", (Object)this.name()).add("Revision", (Object)this.revision()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artifact, T> g) {
        return obj -> g.apply((Artifact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String revision;
        private ArtifactLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            this.name(model.name);
            this.revision(model.revision);
            this.location(model.location);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        @Transient
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final ArtifactLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(ArtifactLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(ArtifactLocation location) {
            this.location = location;
            return this;
        }

        public Artifact build() {
            return new Artifact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Artifact> {
        public Builder name(String var1);

        public Builder revision(String var1);

        public Builder location(ArtifactLocation var1);

        default public Builder location(Consumer<ArtifactLocation.Builder> location) {
            return this.location((ArtifactLocation)((ArtifactLocation.Builder)ArtifactLocation.builder().applyMutation(location)).build());
        }
    }
}

