/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;

public class ListActionExecutionsIterable
implements SdkIterable<ListActionExecutionsResponse> {
    private final CodePipelineClient client;
    private final ListActionExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActionExecutionsIterable(CodePipelineClient client, ListActionExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListActionExecutionsResponseFetcher();
    }

    public Iterator<ListActionExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionExecutionDetail> actionExecutionDetails() {
        Function<ListActionExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionExecutionDetails() != null) {
                return response.actionExecutionDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActionExecutionsResponseFetcher
    implements SyncPageFetcher<ListActionExecutionsResponse> {
        private ListActionExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActionExecutionsResponse nextPage(ListActionExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListActionExecutionsIterable.this.client.listActionExecutions(ListActionExecutionsIterable.this.firstRequest);
            }
            return ListActionExecutionsIterable.this.client.listActionExecutions((ListActionExecutionsRequest)((Object)ListActionExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

