/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CurrentRevision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CurrentRevision> {
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(CurrentRevision.getter(CurrentRevision::revision)).setter(CurrentRevision.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> CHANGE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeIdentifier").getter(CurrentRevision.getter(CurrentRevision::changeIdentifier)).setter(CurrentRevision.setter(Builder::changeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeIdentifier").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(CurrentRevision.getter(CurrentRevision::created)).setter(CurrentRevision.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> REVISION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionSummary").getter(CurrentRevision.getter(CurrentRevision::revisionSummary)).setter(CurrentRevision.setter(Builder::revisionSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_FIELD, CHANGE_IDENTIFIER_FIELD, CREATED_FIELD, REVISION_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String revision;
    private final String changeIdentifier;
    private final Instant created;
    private final String revisionSummary;

    private CurrentRevision(BuilderImpl builder) {
        this.revision = builder.revision;
        this.changeIdentifier = builder.changeIdentifier;
        this.created = builder.created;
        this.revisionSummary = builder.revisionSummary;
    }

    public final String revision() {
        return this.revision;
    }

    public final String changeIdentifier() {
        return this.changeIdentifier;
    }

    public final Instant created() {
        return this.created;
    }

    public final String revisionSummary() {
        return this.revisionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentRevision)) {
            return false;
        }
        CurrentRevision other = (CurrentRevision)obj;
        return Objects.equals(this.revision(), other.revision()) && Objects.equals(this.changeIdentifier(), other.changeIdentifier()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.revisionSummary(), other.revisionSummary());
    }

    public final String toString() {
        return ToString.builder((String)"CurrentRevision").add("Revision", (Object)this.revision()).add("ChangeIdentifier", (Object)this.changeIdentifier()).add("Created", (Object)this.created()).add("RevisionSummary", (Object)this.revisionSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "changeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.changeIdentifier()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "revisionSummary": {
                return Optional.ofNullable(clazz.cast(this.revisionSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentRevision, T> g) {
        return obj -> g.apply((CurrentRevision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String revision;
        private String changeIdentifier;
        private Instant created;
        private String revisionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentRevision model) {
            this.revision(model.revision);
            this.changeIdentifier(model.changeIdentifier);
            this.created(model.created);
            this.revisionSummary(model.revisionSummary);
        }

        public final String getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public final String getChangeIdentifier() {
            return this.changeIdentifier;
        }

        @Override
        public final Builder changeIdentifier(String changeIdentifier) {
            this.changeIdentifier = changeIdentifier;
            return this;
        }

        public final void setChangeIdentifier(String changeIdentifier) {
            this.changeIdentifier = changeIdentifier;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public CurrentRevision build() {
            return new CurrentRevision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CurrentRevision> {
        public Builder revision(String var1);

        public Builder changeIdentifier(String var1);

        public Builder created(Instant var1);

        public Builder revisionSummary(String var1);
    }
}

