/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStore;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStoreMapCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineStageDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PipelineDeclaration.getter(PipelineDeclaration::name)).setter(PipelineDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(PipelineDeclaration.getter(PipelineDeclaration::roleArn)).setter(PipelineDeclaration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ArtifactStore> ARTIFACT_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifactStore").getter(PipelineDeclaration.getter(PipelineDeclaration::artifactStore)).setter(PipelineDeclaration.setter(Builder::artifactStore)).constructor(ArtifactStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStore").build()}).build();
    private static final SdkField<Map<String, ArtifactStore>> ARTIFACT_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("artifactStores").getter(PipelineDeclaration.getter(PipelineDeclaration::artifactStores)).setter(PipelineDeclaration.setter(Builder::artifactStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStores").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<StageDeclaration>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stages").getter(PipelineDeclaration.getter(PipelineDeclaration::stages)).setter(PipelineDeclaration.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("version").getter(PipelineDeclaration.getter(PipelineDeclaration::version)).setter(PipelineDeclaration.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD, ARTIFACT_STORE_FIELD, ARTIFACT_STORES_FIELD, STAGES_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String roleArn;
    private final ArtifactStore artifactStore;
    private final Map<String, ArtifactStore> artifactStores;
    private final List<StageDeclaration> stages;
    private final Integer version;

    private PipelineDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.artifactStore = builder.artifactStore;
        this.artifactStores = builder.artifactStores;
        this.stages = builder.stages;
        this.version = builder.version;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ArtifactStore artifactStore() {
        return this.artifactStore;
    }

    public final boolean hasArtifactStores() {
        return this.artifactStores != null && !(this.artifactStores instanceof SdkAutoConstructMap);
    }

    public final Map<String, ArtifactStore> artifactStores() {
        return this.artifactStores;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<StageDeclaration> stages() {
        return this.stages;
    }

    public final Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactStores() ? this.artifactStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.artifactStore(), other.artifactStore()) && this.hasArtifactStores() == other.hasArtifactStores() && Objects.equals(this.artifactStores(), other.artifactStores()) && this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineDeclaration").add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("ArtifactStore", (Object)this.artifactStore()).add("ArtifactStores", this.hasArtifactStores() ? this.artifactStores() : null).add("Stages", this.hasStages() ? this.stages() : null).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "artifactStore": {
                return Optional.ofNullable(clazz.cast(this.artifactStore()));
            }
            case "artifactStores": {
                return Optional.ofNullable(clazz.cast(this.artifactStores()));
            }
            case "stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDeclaration, T> g) {
        return obj -> g.apply((PipelineDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String roleArn;
        private ArtifactStore artifactStore;
        private Map<String, ArtifactStore> artifactStores = DefaultSdkAutoConstructMap.getInstance();
        private List<StageDeclaration> stages = DefaultSdkAutoConstructList.getInstance();
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDeclaration model) {
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.artifactStore(model.artifactStore);
            this.artifactStores(model.artifactStores);
            this.stages(model.stages);
            this.version(model.version);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final ArtifactStore.Builder getArtifactStore() {
            return this.artifactStore != null ? this.artifactStore.toBuilder() : null;
        }

        @Override
        public final Builder artifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        public final void setArtifactStore(ArtifactStore.BuilderImpl artifactStore) {
            this.artifactStore = artifactStore != null ? artifactStore.build() : null;
        }

        public final Map<String, ArtifactStore.Builder> getArtifactStores() {
            Map<String, ArtifactStore.Builder> result = ArtifactStoreMapCopier.copyToBuilder(this.artifactStores);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder artifactStores(Map<String, ArtifactStore> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copy(artifactStores);
            return this;
        }

        public final void setArtifactStores(Map<String, ArtifactStore.BuilderImpl> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copyFromBuilder(artifactStores);
        }

        public final List<StageDeclaration.Builder> getStages() {
            List<StageDeclaration.Builder> result = PipelineStageDeclarationListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageDeclaration ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<StageDeclaration.Builder> ... stages) {
            this.stages(Stream.of(stages).map(c -> (StageDeclaration)((StageDeclaration.Builder)StageDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStages(Collection<StageDeclaration.BuilderImpl> stages) {
            this.stages = PipelineStageDeclarationListCopier.copyFromBuilder(stages);
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public PipelineDeclaration build() {
            return new PipelineDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineDeclaration> {
        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder artifactStore(ArtifactStore var1);

        default public Builder artifactStore(Consumer<ArtifactStore.Builder> artifactStore) {
            return this.artifactStore((ArtifactStore)((ArtifactStore.Builder)ArtifactStore.builder().applyMutation(artifactStore)).build());
        }

        public Builder artifactStores(Map<String, ArtifactStore> var1);

        public Builder stages(Collection<StageDeclaration> var1);

        public Builder stages(StageDeclaration ... var1);

        public Builder stages(Consumer<StageDeclaration.Builder> ... var1);

        public Builder version(Integer var1);
    }
}

