/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionState;
import software.amazon.awssdk.services.codepipeline.model.ActionStateListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageExecution;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StageState> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageName").getter(StageState.getter(StageState::stageName)).setter(StageState.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<StageExecution> INBOUND_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inboundExecution").getter(StageState.getter(StageState::inboundExecution)).setter(StageState.setter(Builder::inboundExecution)).constructor(StageExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecution").build()}).build();
    private static final SdkField<TransitionState> INBOUND_TRANSITION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inboundTransitionState").getter(StageState.getter(StageState::inboundTransitionState)).setter(StageState.setter(Builder::inboundTransitionState)).constructor(TransitionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundTransitionState").build()}).build();
    private static final SdkField<List<ActionState>> ACTION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionStates").getter(StageState.getter(StageState::actionStates)).setter(StageState.setter(Builder::actionStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StageExecution> LATEST_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestExecution").getter(StageState.getter(StageState::latestExecution)).setter(StageState.setter(Builder::latestExecution)).constructor(StageExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD, INBOUND_EXECUTION_FIELD, INBOUND_TRANSITION_STATE_FIELD, ACTION_STATES_FIELD, LATEST_EXECUTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stageName;
    private final StageExecution inboundExecution;
    private final TransitionState inboundTransitionState;
    private final List<ActionState> actionStates;
    private final StageExecution latestExecution;

    private StageState(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.inboundExecution = builder.inboundExecution;
        this.inboundTransitionState = builder.inboundTransitionState;
        this.actionStates = builder.actionStates;
        this.latestExecution = builder.latestExecution;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final StageExecution inboundExecution() {
        return this.inboundExecution;
    }

    public final TransitionState inboundTransitionState() {
        return this.inboundTransitionState;
    }

    public final boolean hasActionStates() {
        return this.actionStates != null && !(this.actionStates instanceof SdkAutoConstructList);
    }

    public final List<ActionState> actionStates() {
        return this.actionStates;
    }

    public final StageExecution latestExecution() {
        return this.latestExecution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundTransitionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionStates() ? this.actionStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState)obj;
        return Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.inboundExecution(), other.inboundExecution()) && Objects.equals(this.inboundTransitionState(), other.inboundTransitionState()) && this.hasActionStates() == other.hasActionStates() && Objects.equals(this.actionStates(), other.actionStates()) && Objects.equals(this.latestExecution(), other.latestExecution());
    }

    public final String toString() {
        return ToString.builder((String)"StageState").add("StageName", (Object)this.stageName()).add("InboundExecution", (Object)this.inboundExecution()).add("InboundTransitionState", (Object)this.inboundTransitionState()).add("ActionStates", this.hasActionStates() ? this.actionStates() : null).add("LatestExecution", (Object)this.latestExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "inboundExecution": {
                return Optional.ofNullable(clazz.cast(this.inboundExecution()));
            }
            case "inboundTransitionState": {
                return Optional.ofNullable(clazz.cast(this.inboundTransitionState()));
            }
            case "actionStates": {
                return Optional.ofNullable(clazz.cast(this.actionStates()));
            }
            case "latestExecution": {
                return Optional.ofNullable(clazz.cast(this.latestExecution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageState, T> g) {
        return obj -> g.apply((StageState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stageName;
        private StageExecution inboundExecution;
        private TransitionState inboundTransitionState;
        private List<ActionState> actionStates = DefaultSdkAutoConstructList.getInstance();
        private StageExecution latestExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(StageState model) {
            this.stageName(model.stageName);
            this.inboundExecution(model.inboundExecution);
            this.inboundTransitionState(model.inboundTransitionState);
            this.actionStates(model.actionStates);
            this.latestExecution(model.latestExecution);
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final StageExecution.Builder getInboundExecution() {
            return this.inboundExecution != null ? this.inboundExecution.toBuilder() : null;
        }

        @Override
        public final Builder inboundExecution(StageExecution inboundExecution) {
            this.inboundExecution = inboundExecution;
            return this;
        }

        public final void setInboundExecution(StageExecution.BuilderImpl inboundExecution) {
            this.inboundExecution = inboundExecution != null ? inboundExecution.build() : null;
        }

        public final TransitionState.Builder getInboundTransitionState() {
            return this.inboundTransitionState != null ? this.inboundTransitionState.toBuilder() : null;
        }

        @Override
        public final Builder inboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
            return this;
        }

        public final void setInboundTransitionState(TransitionState.BuilderImpl inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState != null ? inboundTransitionState.build() : null;
        }

        public final Collection<ActionState.Builder> getActionStates() {
            if (this.actionStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionStates != null ? (Collection)this.actionStates.stream().map(ActionState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(ActionState ... actionStates) {
            this.actionStates(Arrays.asList(actionStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(Consumer<ActionState.Builder> ... actionStates) {
            this.actionStates(Stream.of(actionStates).map(c -> (ActionState)((ActionState.Builder)ActionState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionStates(Collection<ActionState.BuilderImpl> actionStates) {
            this.actionStates = ActionStateListCopier.copyFromBuilder(actionStates);
        }

        public final StageExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        @Override
        public final Builder latestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final void setLatestExecution(StageExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        public StageState build() {
            return new StageState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StageState> {
        public Builder stageName(String var1);

        public Builder inboundExecution(StageExecution var1);

        default public Builder inboundExecution(Consumer<StageExecution.Builder> inboundExecution) {
            return this.inboundExecution((StageExecution)((StageExecution.Builder)StageExecution.builder().applyMutation(inboundExecution)).build());
        }

        public Builder inboundTransitionState(TransitionState var1);

        default public Builder inboundTransitionState(Consumer<TransitionState.Builder> inboundTransitionState) {
            return this.inboundTransitionState((TransitionState)((TransitionState.Builder)TransitionState.builder().applyMutation(inboundTransitionState)).build());
        }

        public Builder actionStates(Collection<ActionState> var1);

        public Builder actionStates(ActionState ... var1);

        public Builder actionStates(Consumer<ActionState.Builder> ... var1);

        public Builder latestExecution(StageExecution var1);

        default public Builder latestExecution(Consumer<StageExecution.Builder> latestExecution) {
            return this.latestExecution((StageExecution)((StageExecution.Builder)StageExecution.builder().applyMutation(latestExecution)).build());
        }
    }
}

