/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetail;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetailListCopier;
import software.amazon.awssdk.services.codepipeline.model.OutputVariablesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionExecutionOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionExecutionOutput> {
    private static final SdkField<List<ArtifactDetail>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputArtifacts").getter(ActionExecutionOutput.getter(ActionExecutionOutput::outputArtifacts)).setter(ActionExecutionOutput.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ActionExecutionResult> EXECUTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionResult").getter(ActionExecutionOutput.getter(ActionExecutionOutput::executionResult)).setter(ActionExecutionOutput.setter(Builder::executionResult)).constructor(ActionExecutionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build()}).build();
    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("outputVariables").getter(ActionExecutionOutput.getter(ActionExecutionOutput::outputVariables)).setter(ActionExecutionOutput.setter(Builder::outputVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ARTIFACTS_FIELD, EXECUTION_RESULT_FIELD, OUTPUT_VARIABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ArtifactDetail> outputArtifacts;
    private final ActionExecutionResult executionResult;
    private final Map<String, String> outputVariables;

    private ActionExecutionOutput(BuilderImpl builder) {
        this.outputArtifacts = builder.outputArtifacts;
        this.executionResult = builder.executionResult;
        this.outputVariables = builder.outputVariables;
    }

    public boolean hasOutputArtifacts() {
        return this.outputArtifacts != null && !(this.outputArtifacts instanceof SdkAutoConstructList);
    }

    public List<ArtifactDetail> outputArtifacts() {
        return this.outputArtifacts;
    }

    public ActionExecutionResult executionResult() {
        return this.executionResult;
    }

    public boolean hasOutputVariables() {
        return this.outputVariables != null && !(this.outputVariables instanceof SdkAutoConstructMap);
    }

    public Map<String, String> outputVariables() {
        return this.outputVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputArtifacts() ? this.outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputVariables() ? this.outputVariables() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionOutput)) {
            return false;
        }
        ActionExecutionOutput other = (ActionExecutionOutput)obj;
        return this.hasOutputArtifacts() == other.hasOutputArtifacts() && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.executionResult(), other.executionResult()) && this.hasOutputVariables() == other.hasOutputVariables() && Objects.equals(this.outputVariables(), other.outputVariables());
    }

    public String toString() {
        return ToString.builder((String)"ActionExecutionOutput").add("OutputArtifacts", this.hasOutputArtifacts() ? this.outputArtifacts() : null).add("ExecutionResult", (Object)this.executionResult()).add("OutputVariables", this.hasOutputVariables() ? this.outputVariables() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "executionResult": {
                return Optional.ofNullable(clazz.cast(this.executionResult()));
            }
            case "outputVariables": {
                return Optional.ofNullable(clazz.cast(this.outputVariables()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionOutput, T> g) {
        return obj -> g.apply((ActionExecutionOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ArtifactDetail> outputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ActionExecutionResult executionResult;
        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionOutput model) {
            this.outputArtifacts(model.outputArtifacts);
            this.executionResult(model.executionResult);
            this.outputVariables(model.outputVariables);
        }

        public final Collection<ArtifactDetail.Builder> getOutputArtifacts() {
            if (this.outputArtifacts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputArtifacts != null ? (Collection)this.outputArtifacts.stream().map(ArtifactDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputArtifacts(Collection<ArtifactDetail> outputArtifacts) {
            this.outputArtifacts = ArtifactDetailListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(ArtifactDetail ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Consumer<ArtifactDetail.Builder> ... outputArtifacts) {
            this.outputArtifacts(Stream.of(outputArtifacts).map(c -> (ArtifactDetail)((ArtifactDetail.Builder)ArtifactDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputArtifacts(Collection<ArtifactDetail.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = ArtifactDetailListCopier.copyFromBuilder(outputArtifacts);
        }

        public final ActionExecutionResult.Builder getExecutionResult() {
            return this.executionResult != null ? this.executionResult.toBuilder() : null;
        }

        @Override
        public final Builder executionResult(ActionExecutionResult executionResult) {
            this.executionResult = executionResult;
            return this;
        }

        public final void setExecutionResult(ActionExecutionResult.BuilderImpl executionResult) {
            this.executionResult = executionResult != null ? executionResult.build() : null;
        }

        public final Map<String, String> getOutputVariables() {
            if (this.outputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputVariables;
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
            return this;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
        }

        public ActionExecutionOutput build() {
            return new ActionExecutionOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionExecutionOutput> {
        public Builder outputArtifacts(Collection<ArtifactDetail> var1);

        public Builder outputArtifacts(ArtifactDetail ... var1);

        public Builder outputArtifacts(Consumer<ArtifactDetail.Builder> ... var1);

        public Builder executionResult(ActionExecutionResult var1);

        default public Builder executionResult(Consumer<ActionExecutionResult.Builder> executionResult) {
            return this.executionResult((ActionExecutionResult)((ActionExecutionResult.Builder)ActionExecutionResult.builder().applyMutation(executionResult)).build());
        }

        public Builder outputVariables(Map<String, String> var1);
    }
}

