/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionExecution;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionState> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(ActionState.getter(ActionState::actionName)).setter(ActionState.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<ActionRevision> CURRENT_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentRevision").getter(ActionState.getter(ActionState::currentRevision)).setter(ActionState.setter(Builder::currentRevision)).constructor(ActionRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()}).build();
    private static final SdkField<ActionExecution> LATEST_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestExecution").getter(ActionState.getter(ActionState::latestExecution)).setter(ActionState.setter(Builder::latestExecution)).constructor(ActionExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()}).build();
    private static final SdkField<String> ENTITY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityUrl").getter(ActionState.getter(ActionState::entityUrl)).setter(ActionState.setter(Builder::entityUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityUrl").build()}).build();
    private static final SdkField<String> REVISION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionUrl").getter(ActionState.getter(ActionState::revisionUrl)).setter(ActionState.setter(Builder::revisionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, CURRENT_REVISION_FIELD, LATEST_EXECUTION_FIELD, ENTITY_URL_FIELD, REVISION_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final ActionRevision currentRevision;
    private final ActionExecution latestExecution;
    private final String entityUrl;
    private final String revisionUrl;

    private ActionState(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.currentRevision = builder.currentRevision;
        this.latestExecution = builder.latestExecution;
        this.entityUrl = builder.entityUrl;
        this.revisionUrl = builder.revisionUrl;
    }

    public String actionName() {
        return this.actionName;
    }

    public ActionRevision currentRevision() {
        return this.currentRevision;
    }

    public ActionExecution latestExecution() {
        return this.latestExecution;
    }

    public String entityUrl() {
        return this.entityUrl;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionState)) {
            return false;
        }
        ActionState other = (ActionState)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.currentRevision(), other.currentRevision()) && Objects.equals(this.latestExecution(), other.latestExecution()) && Objects.equals(this.entityUrl(), other.entityUrl()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public String toString() {
        return ToString.builder((String)"ActionState").add("ActionName", (Object)this.actionName()).add("CurrentRevision", (Object)this.currentRevision()).add("LatestExecution", (Object)this.latestExecution()).add("EntityUrl", (Object)this.entityUrl()).add("RevisionUrl", (Object)this.revisionUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "currentRevision": {
                return Optional.ofNullable(clazz.cast(this.currentRevision()));
            }
            case "latestExecution": {
                return Optional.ofNullable(clazz.cast(this.latestExecution()));
            }
            case "entityUrl": {
                return Optional.ofNullable(clazz.cast(this.entityUrl()));
            }
            case "revisionUrl": {
                return Optional.ofNullable(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionState, T> g) {
        return obj -> g.apply((ActionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private ActionRevision currentRevision;
        private ActionExecution latestExecution;
        private String entityUrl;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionState model) {
            this.actionName(model.actionName);
            this.currentRevision(model.currentRevision);
            this.latestExecution(model.latestExecution);
            this.entityUrl(model.entityUrl);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ActionRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        @Override
        public final Builder currentRevision(ActionRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final void setCurrentRevision(ActionRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        public final ActionExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        @Override
        public final Builder latestExecution(ActionExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final void setLatestExecution(ActionExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        public final String getEntityUrl() {
            return this.entityUrl;
        }

        @Override
        public final Builder entityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        public final void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        public ActionState build() {
            return new ActionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionState> {
        public Builder actionName(String var1);

        public Builder currentRevision(ActionRevision var1);

        default public Builder currentRevision(Consumer<ActionRevision.Builder> currentRevision) {
            return this.currentRevision((ActionRevision)((ActionRevision.Builder)ActionRevision.builder().applyMutation(currentRevision)).build());
        }

        public Builder latestExecution(ActionExecution var1);

        default public Builder latestExecution(Consumer<ActionExecution.Builder> latestExecution) {
            return this.latestExecution((ActionExecution)((ActionExecution.Builder)ActionExecution.builder().applyMutation(latestExecution)).build());
        }

        public Builder entityUrl(String var1);

        public Builder revisionUrl(String var1);
    }
}

