/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArtifactDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArtifactDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ArtifactDetail.getter(ArtifactDetail::name)).setter(ArtifactDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3location").getter(ArtifactDetail.getter(ArtifactDetail::s3location)).setter(ArtifactDetail.setter(Builder::s3location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, S3_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final S3Location s3location;

    private ArtifactDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.s3location = builder.s3location;
    }

    public String name() {
        return this.name;
    }

    public S3Location s3location() {
        return this.s3location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactDetail)) {
            return false;
        }
        ArtifactDetail other = (ArtifactDetail)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.s3location(), other.s3location());
    }

    public String toString() {
        return ToString.builder((String)"ArtifactDetail").add("Name", (Object)this.name()).add("S3location", (Object)this.s3location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "s3location": {
                return Optional.ofNullable(clazz.cast(this.s3location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactDetail, T> g) {
        return obj -> g.apply((ArtifactDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private S3Location s3location;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactDetail model) {
            this.name(model.name);
            this.s3location(model.s3location);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final S3Location.Builder getS3location() {
            return this.s3location != null ? this.s3location.toBuilder() : null;
        }

        @Override
        public final Builder s3location(S3Location s3location) {
            this.s3location = s3location;
            return this;
        }

        public final void setS3location(S3Location.BuilderImpl s3location) {
            this.s3location = s3location != null ? s3location.build() : null;
        }

        public ArtifactDetail build() {
            return new ArtifactDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArtifactDetail> {
        public Builder name(String var1);

        public Builder s3location(S3Location var1);

        default public Builder s3location(Consumer<S3Location.Builder> s3location) {
            return this.s3location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3location)).build());
        }
    }
}

