/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ArtifactLocationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").isBinary(false).build();
    private static final MarshallingInfo<String> OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectKey").isBinary(false).build();
    private static final S3ArtifactLocationMarshaller INSTANCE = new S3ArtifactLocationMarshaller();

    private S3ArtifactLocationMarshaller() {
    }

    public static S3ArtifactLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3ArtifactLocation s3ArtifactLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3ArtifactLocation, (String)"s3ArtifactLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3ArtifactLocation.bucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3ArtifactLocation.objectKey(), OBJECTKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

