/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.FailureDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutJobFailureResultRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PutJobFailureResultRequest> {
    private final String jobId;
    private final FailureDetails failureDetails;

    private PutJobFailureResultRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.failureDetails = builder.failureDetails;
    }

    public String jobId() {
        return this.jobId;
    }

    public FailureDetails failureDetails() {
        return this.failureDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutJobFailureResultRequest)) {
            return false;
        }
        PutJobFailureResultRequest other = (PutJobFailureResultRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.failureDetails(), other.failureDetails());
    }

    public String toString() {
        return ToString.builder((String)"PutJobFailureResultRequest").add("JobId", (Object)this.jobId()).add("FailureDetails", (Object)this.failureDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "failureDetails": {
                return Optional.of(clazz.cast(this.failureDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private FailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutJobFailureResultRequest model) {
            this.jobId(model.jobId);
            this.failureDetails(model.failureDetails);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutJobFailureResultRequest build() {
            return new PutJobFailureResultRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, PutJobFailureResultRequest> {
        public Builder jobId(String var1);

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().apply(failureDetails)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

