/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutActionRevisionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PutActionRevisionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String actionName;
    private final ActionRevision actionRevision;

    private PutActionRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.actionRevision = builder.actionRevision;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String actionName() {
        return this.actionName;
    }

    public ActionRevision actionRevision() {
        return this.actionRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionRevision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionRevisionRequest)) {
            return false;
        }
        PutActionRevisionRequest other = (PutActionRevisionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.actionRevision(), other.actionRevision());
    }

    public String toString() {
        return ToString.builder((String)"PutActionRevisionRequest").add("PipelineName", (Object)this.pipelineName()).add("StageName", (Object)this.stageName()).add("ActionName", (Object)this.actionName()).add("ActionRevision", (Object)this.actionRevision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "actionName": {
                return Optional.of(clazz.cast(this.actionName()));
            }
            case "actionRevision": {
                return Optional.of(clazz.cast(this.actionRevision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String actionName;
        private ActionRevision actionRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionRevisionRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.actionName(model.actionName);
            this.actionRevision(model.actionRevision);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ActionRevision.Builder getActionRevision() {
            return this.actionRevision != null ? this.actionRevision.toBuilder() : null;
        }

        @Override
        public final Builder actionRevision(ActionRevision actionRevision) {
            this.actionRevision = actionRevision;
            return this;
        }

        public final void setActionRevision(ActionRevision.BuilderImpl actionRevision) {
            this.actionRevision = actionRevision != null ? actionRevision.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutActionRevisionRequest build() {
            return new PutActionRevisionRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, PutActionRevisionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder actionName(String var1);

        public Builder actionRevision(ActionRevision var1);

        default public Builder actionRevision(Consumer<ActionRevision.Builder> actionRevision) {
            return this.actionRevision((ActionRevision)((ActionRevision.Builder)ActionRevision.builder().apply(actionRevision)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

