/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPipelineExecutionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, GetPipelineExecutionRequest> {
    private final String pipelineName;
    private final String pipelineExecutionId;

    private GetPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineExecutionRequest)) {
            return false;
        }
        GetPipelineExecutionRequest other = (GetPipelineExecutionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId());
    }

    public String toString() {
        return ToString.builder((String)"GetPipelineExecutionRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "pipelineExecutionId": {
                return Optional.of(clazz.cast(this.pipelineExecutionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineExecutionRequest model) {
            this.pipelineName(model.pipelineName);
            this.pipelineExecutionId(model.pipelineExecutionId);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetPipelineExecutionRequest build() {
            return new GetPipelineExecutionRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, GetPipelineExecutionRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineExecutionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

