/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationMapCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.InputArtifact;
import software.amazon.awssdk.services.codepipeline.model.InputArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifact;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.transform.ActionDeclarationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionDeclaration
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionDeclaration> {
    private final String name;
    private final ActionTypeId actionTypeId;
    private final Integer runOrder;
    private final Map<String, String> configuration;
    private final List<OutputArtifact> outputArtifacts;
    private final List<InputArtifact> inputArtifacts;
    private final String roleArn;

    private ActionDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.actionTypeId = builder.actionTypeId;
        this.runOrder = builder.runOrder;
        this.configuration = builder.configuration;
        this.outputArtifacts = builder.outputArtifacts;
        this.inputArtifacts = builder.inputArtifacts;
        this.roleArn = builder.roleArn;
    }

    public String name() {
        return this.name;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public Integer runOrder() {
        return this.runOrder;
    }

    public Map<String, String> configuration() {
        return this.configuration;
    }

    public List<OutputArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public List<InputArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionDeclaration)) {
            return false;
        }
        ActionDeclaration other = (ActionDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.runOrder(), other.runOrder()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"ActionDeclaration").add("Name", (Object)this.name()).add("ActionTypeId", (Object)this.actionTypeId()).add("RunOrder", (Object)this.runOrder()).add("Configuration", this.configuration()).add("OutputArtifacts", this.outputArtifacts()).add("InputArtifacts", this.inputArtifacts()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "actionTypeId": {
                return Optional.of(clazz.cast(this.actionTypeId()));
            }
            case "runOrder": {
                return Optional.of(clazz.cast(this.runOrder()));
            }
            case "configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
            case "outputArtifacts": {
                return Optional.of(clazz.cast(this.outputArtifacts()));
            }
            case "inputArtifacts": {
                return Optional.of(clazz.cast(this.inputArtifacts()));
            }
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ActionTypeId actionTypeId;
        private Integer runOrder;
        private Map<String, String> configuration;
        private List<OutputArtifact> outputArtifacts;
        private List<InputArtifact> inputArtifacts;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionDeclaration model) {
            this.name(model.name);
            this.actionTypeId(model.actionTypeId);
            this.runOrder(model.runOrder);
            this.configuration(model.configuration);
            this.outputArtifacts(model.outputArtifacts);
            this.inputArtifacts(model.inputArtifacts);
            this.roleArn(model.roleArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        public final Integer getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final Builder runOrder(Integer runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public final void setRunOrder(Integer runOrder) {
            this.runOrder = runOrder;
        }

        public final Map<String, String> getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        public final Collection<OutputArtifact.Builder> getOutputArtifacts() {
            return this.outputArtifacts != null ? (Collection)this.outputArtifacts.stream().map(OutputArtifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputArtifacts(Collection<OutputArtifact> outputArtifacts) {
            this.outputArtifacts = OutputArtifactListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(OutputArtifact ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        public final void setOutputArtifacts(Collection<OutputArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = OutputArtifactListCopier.copyFromBuilder(outputArtifacts);
        }

        public final Collection<InputArtifact.Builder> getInputArtifacts() {
            return this.inputArtifacts != null ? (Collection)this.inputArtifacts.stream().map(InputArtifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputArtifacts(Collection<InputArtifact> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(InputArtifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        public final void setInputArtifacts(Collection<InputArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copyFromBuilder(inputArtifacts);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public ActionDeclaration build() {
            return new ActionDeclaration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionDeclaration> {
        public Builder name(String var1);

        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().apply(actionTypeId)).build());
        }

        public Builder runOrder(Integer var1);

        public Builder configuration(Map<String, String> var1);

        public Builder outputArtifacts(Collection<OutputArtifact> var1);

        public Builder outputArtifacts(OutputArtifact ... var1);

        public Builder inputArtifacts(Collection<InputArtifact> var1);

        public Builder inputArtifacts(InputArtifact ... var1);

        public Builder roleArn(String var1);
    }
}

