/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;

@SdkInternalApi
public class ActionTypeIdMarshaller {
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owner").build();
    private static final MarshallingInfo<String> PROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("provider").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final ActionTypeIdMarshaller INSTANCE = new ActionTypeIdMarshaller();

    public static ActionTypeIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionTypeId actionTypeId, ProtocolMarshaller protocolMarshaller) {
        if (actionTypeId == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)actionTypeId.categoryString(), CATEGORY_BINDING);
            protocolMarshaller.marshall((Object)actionTypeId.ownerString(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)actionTypeId.provider(), PROVIDER_BINDING);
            protocolMarshaller.marshall((Object)actionTypeId.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

