/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType;
import software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArtifactLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, ArtifactLocation> {
    private final String type;
    private final S3ArtifactLocation s3Location;

    private ArtifactLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Location = builder.s3Location;
    }

    public ArtifactLocationType type() {
        return ArtifactLocationType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public S3ArtifactLocation s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactLocation)) {
            return false;
        }
        ArtifactLocation other = (ArtifactLocation)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.s3Location() != null) {
            sb.append("S3Location: ").append(this.s3Location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "s3Location": {
                return Optional.of(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private S3ArtifactLocation s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactLocation model) {
            this.type(model.type);
            this.s3Location(model.s3Location);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactLocationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final S3ArtifactLocation.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3ArtifactLocation s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3ArtifactLocation.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public ArtifactLocation build() {
            return new ArtifactLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArtifactLocation> {
        public Builder type(String var1);

        public Builder type(ArtifactLocationType var1);

        public Builder s3Location(S3ArtifactLocation var1);

        default public Builder s3Location(Consumer<S3ArtifactLocation.Builder> s3Location) {
            return this.s3Location((S3ArtifactLocation)((S3ArtifactLocation.Builder)S3ArtifactLocation.builder().apply(s3Location)).build());
        }
    }
}

