/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionExecution;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;
import software.amazon.awssdk.services.codepipeline.transform.ActionStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionState
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionState> {
    private final String actionName;
    private final ActionRevision currentRevision;
    private final ActionExecution latestExecution;
    private final String entityUrl;
    private final String revisionUrl;

    private ActionState(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.currentRevision = builder.currentRevision;
        this.latestExecution = builder.latestExecution;
        this.entityUrl = builder.entityUrl;
        this.revisionUrl = builder.revisionUrl;
    }

    public String actionName() {
        return this.actionName;
    }

    public ActionRevision currentRevision() {
        return this.currentRevision;
    }

    public ActionExecution latestExecution() {
        return this.latestExecution;
    }

    public String entityUrl() {
        return this.entityUrl;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionState)) {
            return false;
        }
        ActionState other = (ActionState)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.currentRevision(), other.currentRevision()) && Objects.equals(this.latestExecution(), other.latestExecution()) && Objects.equals(this.entityUrl(), other.entityUrl()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionName() != null) {
            sb.append("ActionName: ").append(this.actionName()).append(",");
        }
        if (this.currentRevision() != null) {
            sb.append("CurrentRevision: ").append(this.currentRevision()).append(",");
        }
        if (this.latestExecution() != null) {
            sb.append("LatestExecution: ").append(this.latestExecution()).append(",");
        }
        if (this.entityUrl() != null) {
            sb.append("EntityUrl: ").append(this.entityUrl()).append(",");
        }
        if (this.revisionUrl() != null) {
            sb.append("RevisionUrl: ").append(this.revisionUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.of(clazz.cast(this.actionName()));
            }
            case "currentRevision": {
                return Optional.of(clazz.cast(this.currentRevision()));
            }
            case "latestExecution": {
                return Optional.of(clazz.cast(this.latestExecution()));
            }
            case "entityUrl": {
                return Optional.of(clazz.cast(this.entityUrl()));
            }
            case "revisionUrl": {
                return Optional.of(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private ActionRevision currentRevision;
        private ActionExecution latestExecution;
        private String entityUrl;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionState model) {
            this.actionName(model.actionName);
            this.currentRevision(model.currentRevision);
            this.latestExecution(model.latestExecution);
            this.entityUrl(model.entityUrl);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ActionRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        @Override
        public final Builder currentRevision(ActionRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final void setCurrentRevision(ActionRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        public final ActionExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        @Override
        public final Builder latestExecution(ActionExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final void setLatestExecution(ActionExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        public final String getEntityUrl() {
            return this.entityUrl;
        }

        @Override
        public final Builder entityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        public final void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        public ActionState build() {
            return new ActionState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionState> {
        public Builder actionName(String var1);

        public Builder currentRevision(ActionRevision var1);

        default public Builder currentRevision(Consumer<ActionRevision.Builder> currentRevision) {
            return this.currentRevision((ActionRevision)((ActionRevision.Builder)ActionRevision.builder().apply(currentRevision)).build());
        }

        public Builder latestExecution(ActionExecution var1);

        default public Builder latestExecution(Consumer<ActionExecution.Builder> latestExecution) {
            return this.latestExecution((ActionExecution)((ActionExecution.Builder)ActionExecution.builder().apply(latestExecution)).build());
        }

        public Builder entityUrl(String var1);

        public Builder revisionUrl(String var1);
    }
}

