/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.CurrentRevision;
import software.amazon.awssdk.services.codepipeline.model.ExecutionDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutThirdPartyJobSuccessResultRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutThirdPartyJobSuccessResultRequest> {
    private final String jobId;
    private final String clientToken;
    private final CurrentRevision currentRevision;
    private final String continuationToken;
    private final ExecutionDetails executionDetails;

    private PutThirdPartyJobSuccessResultRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.clientToken = builder.clientToken;
        this.currentRevision = builder.currentRevision;
        this.continuationToken = builder.continuationToken;
        this.executionDetails = builder.executionDetails;
    }

    public String jobId() {
        return this.jobId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public CurrentRevision currentRevision() {
        return this.currentRevision;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public ExecutionDetails executionDetails() {
        return this.executionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutThirdPartyJobSuccessResultRequest)) {
            return false;
        }
        PutThirdPartyJobSuccessResultRequest other = (PutThirdPartyJobSuccessResultRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.currentRevision(), other.currentRevision()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.executionDetails(), other.executionDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.currentRevision() != null) {
            sb.append("CurrentRevision: ").append(this.currentRevision()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.executionDetails() != null) {
            sb.append("ExecutionDetails: ").append(this.executionDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "clientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "currentRevision": {
                return Optional.of(clazz.cast(this.currentRevision()));
            }
            case "continuationToken": {
                return Optional.of(clazz.cast(this.continuationToken()));
            }
            case "executionDetails": {
                return Optional.of(clazz.cast(this.executionDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String clientToken;
        private CurrentRevision currentRevision;
        private String continuationToken;
        private ExecutionDetails executionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutThirdPartyJobSuccessResultRequest model) {
            this.jobId(model.jobId);
            this.clientToken(model.clientToken);
            this.currentRevision(model.currentRevision);
            this.continuationToken(model.continuationToken);
            this.executionDetails(model.executionDetails);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final CurrentRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        @Override
        public final Builder currentRevision(CurrentRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final void setCurrentRevision(CurrentRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return this.executionDetails != null ? this.executionDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        public PutThirdPartyJobSuccessResultRequest build() {
            return new PutThirdPartyJobSuccessResultRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutThirdPartyJobSuccessResultRequest> {
        public Builder jobId(String var1);

        public Builder clientToken(String var1);

        public Builder currentRevision(CurrentRevision var1);

        default public Builder currentRevision(Consumer<CurrentRevision.Builder> currentRevision) {
            return this.currentRevision((CurrentRevision)((CurrentRevision.Builder)CurrentRevision.builder().apply(currentRevision)).build());
        }

        public Builder continuationToken(String var1);

        public Builder executionDetails(ExecutionDetails var1);

        default public Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return this.executionDetails((ExecutionDetails)((ExecutionDetails.Builder)ExecutionDetails.builder().apply(executionDetails)).build());
        }
    }
}

