/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.FailureDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutThirdPartyJobFailureResultRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutThirdPartyJobFailureResultRequest> {
    private final String jobId;
    private final String clientToken;
    private final FailureDetails failureDetails;

    private PutThirdPartyJobFailureResultRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.clientToken = builder.clientToken;
        this.failureDetails = builder.failureDetails;
    }

    public String jobId() {
        return this.jobId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutThirdPartyJobFailureResultRequest)) {
            return false;
        }
        PutThirdPartyJobFailureResultRequest other = (PutThirdPartyJobFailureResultRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.failureDetails(), other.failureDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.failureDetails() != null) {
            sb.append("FailureDetails: ").append(this.failureDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "clientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "failureDetails": {
                return Optional.of(clazz.cast(this.failureDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String clientToken;
        private FailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutThirdPartyJobFailureResultRequest model) {
            this.jobId(model.jobId);
            this.clientToken(model.clientToken);
            this.failureDetails(model.failureDetails);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        public PutThirdPartyJobFailureResultRequest build() {
            return new PutThirdPartyJobFailureResultRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutThirdPartyJobFailureResultRequest> {
        public Builder jobId(String var1);

        public Builder clientToken(String var1);

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().apply(failureDetails)).build());
        }
    }
}

