/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForThirdPartyJobsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PollForThirdPartyJobsRequest> {
    private final ActionTypeId actionTypeId;
    private final Integer maxBatchSize;

    private PollForThirdPartyJobsRequest(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForThirdPartyJobsRequest)) {
            return false;
        }
        PollForThirdPartyJobsRequest other = (PollForThirdPartyJobsRequest)((Object)obj);
        return Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.maxBatchSize(), other.maxBatchSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionTypeId() != null) {
            sb.append("ActionTypeId: ").append(this.actionTypeId()).append(",");
        }
        if (this.maxBatchSize() != null) {
            sb.append("MaxBatchSize: ").append(this.maxBatchSize()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypeId": {
                return Optional.of(clazz.cast(this.actionTypeId()));
            }
            case "maxBatchSize": {
                return Optional.of(clazz.cast(this.maxBatchSize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private Integer maxBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForThirdPartyJobsRequest model) {
            this.actionTypeId(model.actionTypeId);
            this.maxBatchSize(model.maxBatchSize);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public PollForThirdPartyJobsRequest build() {
            return new PollForThirdPartyJobsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForThirdPartyJobsRequest> {
        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().apply(actionTypeId)).build());
        }

        public Builder maxBatchSize(Integer var1);
    }
}

