/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutActionRevisionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutActionRevisionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String actionName;
    private final ActionRevision actionRevision;

    private PutActionRevisionRequest(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.actionRevision = builder.actionRevision;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String actionName() {
        return this.actionName;
    }

    public ActionRevision actionRevision() {
        return this.actionRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.actionName() == null ? 0 : this.actionName().hashCode());
        hashCode = 31 * hashCode + (this.actionRevision() == null ? 0 : this.actionRevision().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionRevisionRequest)) {
            return false;
        }
        PutActionRevisionRequest other = (PutActionRevisionRequest)((Object)obj);
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.actionName() == null ^ this.actionName() == null) {
            return false;
        }
        if (other.actionName() != null && !other.actionName().equals(this.actionName())) {
            return false;
        }
        if (other.actionRevision() == null ^ this.actionRevision() == null) {
            return false;
        }
        return other.actionRevision() == null || other.actionRevision().equals(this.actionRevision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.actionName() != null) {
            sb.append("ActionName: ").append(this.actionName()).append(",");
        }
        if (this.actionRevision() != null) {
            sb.append("ActionRevision: ").append(this.actionRevision()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "actionName": {
                return Optional.of(clazz.cast(this.actionName()));
            }
            case "actionRevision": {
                return Optional.of(clazz.cast(this.actionRevision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String actionName;
        private ActionRevision actionRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionRevisionRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.actionName(model.actionName);
            this.actionRevision(model.actionRevision);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ActionRevision.Builder getActionRevision() {
            return this.actionRevision != null ? this.actionRevision.toBuilder() : null;
        }

        @Override
        public final Builder actionRevision(ActionRevision actionRevision) {
            this.actionRevision = actionRevision;
            return this;
        }

        public final void setActionRevision(ActionRevision.BuilderImpl actionRevision) {
            this.actionRevision = actionRevision != null ? actionRevision.build() : null;
        }

        public PutActionRevisionRequest build() {
            return new PutActionRevisionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutActionRevisionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder actionName(String var1);

        public Builder actionRevision(ActionRevision var1);
    }
}

