/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeSettingsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionTypeSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionTypeSettings> {
    private final String thirdPartyConfigurationUrl;
    private final String entityUrlTemplate;
    private final String executionUrlTemplate;
    private final String revisionUrlTemplate;

    private ActionTypeSettings(BuilderImpl builder) {
        this.thirdPartyConfigurationUrl = builder.thirdPartyConfigurationUrl;
        this.entityUrlTemplate = builder.entityUrlTemplate;
        this.executionUrlTemplate = builder.executionUrlTemplate;
        this.revisionUrlTemplate = builder.revisionUrlTemplate;
    }

    public String thirdPartyConfigurationUrl() {
        return this.thirdPartyConfigurationUrl;
    }

    public String entityUrlTemplate() {
        return this.entityUrlTemplate;
    }

    public String executionUrlTemplate() {
        return this.executionUrlTemplate;
    }

    public String revisionUrlTemplate() {
        return this.revisionUrlTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.thirdPartyConfigurationUrl() == null ? 0 : this.thirdPartyConfigurationUrl().hashCode());
        hashCode = 31 * hashCode + (this.entityUrlTemplate() == null ? 0 : this.entityUrlTemplate().hashCode());
        hashCode = 31 * hashCode + (this.executionUrlTemplate() == null ? 0 : this.executionUrlTemplate().hashCode());
        hashCode = 31 * hashCode + (this.revisionUrlTemplate() == null ? 0 : this.revisionUrlTemplate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeSettings)) {
            return false;
        }
        ActionTypeSettings other = (ActionTypeSettings)obj;
        if (other.thirdPartyConfigurationUrl() == null ^ this.thirdPartyConfigurationUrl() == null) {
            return false;
        }
        if (other.thirdPartyConfigurationUrl() != null && !other.thirdPartyConfigurationUrl().equals(this.thirdPartyConfigurationUrl())) {
            return false;
        }
        if (other.entityUrlTemplate() == null ^ this.entityUrlTemplate() == null) {
            return false;
        }
        if (other.entityUrlTemplate() != null && !other.entityUrlTemplate().equals(this.entityUrlTemplate())) {
            return false;
        }
        if (other.executionUrlTemplate() == null ^ this.executionUrlTemplate() == null) {
            return false;
        }
        if (other.executionUrlTemplate() != null && !other.executionUrlTemplate().equals(this.executionUrlTemplate())) {
            return false;
        }
        if (other.revisionUrlTemplate() == null ^ this.revisionUrlTemplate() == null) {
            return false;
        }
        return other.revisionUrlTemplate() == null || other.revisionUrlTemplate().equals(this.revisionUrlTemplate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.thirdPartyConfigurationUrl() != null) {
            sb.append("ThirdPartyConfigurationUrl: ").append(this.thirdPartyConfigurationUrl()).append(",");
        }
        if (this.entityUrlTemplate() != null) {
            sb.append("EntityUrlTemplate: ").append(this.entityUrlTemplate()).append(",");
        }
        if (this.executionUrlTemplate() != null) {
            sb.append("ExecutionUrlTemplate: ").append(this.executionUrlTemplate()).append(",");
        }
        if (this.revisionUrlTemplate() != null) {
            sb.append("RevisionUrlTemplate: ").append(this.revisionUrlTemplate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionTypeSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String thirdPartyConfigurationUrl;
        private String entityUrlTemplate;
        private String executionUrlTemplate;
        private String revisionUrlTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeSettings model) {
            this.setThirdPartyConfigurationUrl(model.thirdPartyConfigurationUrl);
            this.setEntityUrlTemplate(model.entityUrlTemplate);
            this.setExecutionUrlTemplate(model.executionUrlTemplate);
            this.setRevisionUrlTemplate(model.revisionUrlTemplate);
        }

        public final String getThirdPartyConfigurationUrl() {
            return this.thirdPartyConfigurationUrl;
        }

        @Override
        public final Builder thirdPartyConfigurationUrl(String thirdPartyConfigurationUrl) {
            this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
            return this;
        }

        public final void setThirdPartyConfigurationUrl(String thirdPartyConfigurationUrl) {
            this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
        }

        public final String getEntityUrlTemplate() {
            return this.entityUrlTemplate;
        }

        @Override
        public final Builder entityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
            return this;
        }

        public final void setEntityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
        }

        public final String getExecutionUrlTemplate() {
            return this.executionUrlTemplate;
        }

        @Override
        public final Builder executionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
            return this;
        }

        public final void setExecutionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
        }

        public final String getRevisionUrlTemplate() {
            return this.revisionUrlTemplate;
        }

        @Override
        public final Builder revisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
            return this;
        }

        public final void setRevisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
        }

        public ActionTypeSettings build() {
            return new ActionTypeSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionTypeSettings> {
        public Builder thirdPartyConfigurationUrl(String var1);

        public Builder entityUrlTemplate(String var1);

        public Builder executionUrlTemplate(String var1);

        public Builder revisionUrlTemplate(String var1);
    }
}

