/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionExecution;

@SdkInternalApi
public class ActionExecutionMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").build();
    private static final MarshallingInfo<Instant> LASTSTATUSCHANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatusChange").build();
    private static final MarshallingInfo<String> TOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("token").build();
    private static final MarshallingInfo<String> LASTUPDATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedBy").build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionId").build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionUrl").build();
    private static final MarshallingInfo<Integer> PERCENTCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentComplete").build();
    private static final MarshallingInfo<StructuredPojo> ERRORDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorDetails").build();
    private static final ActionExecutionMarshaller INSTANCE = new ActionExecutionMarshaller();

    public static ActionExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionExecution actionExecution, ProtocolMarshaller protocolMarshaller) {
        if (actionExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)actionExecution.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.summary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.lastStatusChange(), LASTSTATUSCHANGE_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.token(), TOKEN_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.lastUpdatedBy(), LASTUPDATEDBY_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.externalExecutionId(), EXTERNALEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.externalExecutionUrl(), EXTERNALEXECUTIONURL_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.percentComplete(), PERCENTCOMPLETE_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.errorDetails(), ERRORDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

