/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.StageState;
import software.amazon.awssdk.services.codepipeline.model.StageStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPipelineStateResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetPipelineStateResponse> {
    private final String pipelineName;
    private final Integer pipelineVersion;
    private final List<StageState> stageStates;
    private final Instant created;
    private final Instant updated;

    private GetPipelineStateResponse(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageStates = builder.stageStates;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public List<StageState> stageStates() {
        return this.stageStates;
    }

    public Instant created() {
        return this.created;
    }

    public Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.pipelineVersion() == null ? 0 : this.pipelineVersion().hashCode());
        hashCode = 31 * hashCode + (this.stageStates() == null ? 0 : this.stageStates().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.updated() == null ? 0 : this.updated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineStateResponse)) {
            return false;
        }
        GetPipelineStateResponse other = (GetPipelineStateResponse)((Object)obj);
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.pipelineVersion() == null ^ this.pipelineVersion() == null) {
            return false;
        }
        if (other.pipelineVersion() != null && !other.pipelineVersion().equals(this.pipelineVersion())) {
            return false;
        }
        if (other.stageStates() == null ^ this.stageStates() == null) {
            return false;
        }
        if (other.stageStates() != null && !other.stageStates().equals(this.stageStates())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.updated() == null ^ this.updated() == null) {
            return false;
        }
        return other.updated() == null || other.updated().equals(this.updated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.pipelineVersion() != null) {
            sb.append("PipelineVersion: ").append(this.pipelineVersion()).append(",");
        }
        if (this.stageStates() != null) {
            sb.append("StageStates: ").append(this.stageStates()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.updated() != null) {
            sb.append("Updated: ").append(this.updated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer pipelineVersion;
        private List<StageState> stageStates;
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineStateResponse model) {
            this.setPipelineName(model.pipelineName);
            this.setPipelineVersion(model.pipelineVersion);
            this.setStageStates(model.stageStates);
            this.setCreated(model.created);
            this.setUpdated(model.updated);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final Collection<StageState> getStageStates() {
            return this.stageStates;
        }

        @Override
        public final Builder stageStates(Collection<StageState> stageStates) {
            this.stageStates = StageStateListCopier.copy(stageStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageStates(StageState ... stageStates) {
            this.stageStates(Arrays.asList(stageStates));
            return this;
        }

        public final void setStageStates(Collection<StageState> stageStates) {
            this.stageStates = StageStateListCopier.copy(stageStates);
        }

        @SafeVarargs
        public final void setStageStates(StageState ... stageStates) {
            this.stageStates(Arrays.asList(stageStates));
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public GetPipelineStateResponse build() {
            return new GetPipelineStateResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetPipelineStateResponse> {
        public Builder pipelineName(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder stageStates(Collection<StageState> var1);

        public Builder stageStates(StageState ... var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

