/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.WebhookDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WebhookDefinitionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETPIPELINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetPipeline").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetAction").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filters").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authentication").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUTHENTICATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authenticationConfiguration").isBinary(false).build();
    private static final WebhookDefinitionMarshaller INSTANCE = new WebhookDefinitionMarshaller();

    private WebhookDefinitionMarshaller() {
    }

    public static WebhookDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WebhookDefinition webhookDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)webhookDefinition, (String)"webhookDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)webhookDefinition.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)webhookDefinition.targetPipeline(), TARGETPIPELINE_BINDING);
            protocolMarshaller.marshall((Object)webhookDefinition.targetAction(), TARGETACTION_BINDING);
            protocolMarshaller.marshall(webhookDefinition.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)webhookDefinition.authenticationAsString(), AUTHENTICATION_BINDING);
            protocolMarshaller.marshall((Object)webhookDefinition.authenticationConfiguration(), AUTHENTICATIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

