/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StageDeclarationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<List> BLOCKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blockers").isBinary(false).build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").isBinary(false).build();
    private static final StageDeclarationMarshaller INSTANCE = new StageDeclarationMarshaller();

    private StageDeclarationMarshaller() {
    }

    public static StageDeclarationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StageDeclaration stageDeclaration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stageDeclaration, (String)"stageDeclaration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stageDeclaration.name(), NAME_BINDING);
            protocolMarshaller.marshall(stageDeclaration.blockers(), BLOCKERS_BINDING);
            protocolMarshaller.marshall(stageDeclaration.actions(), ACTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

