/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.SourceRevision;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceRevisionMarshaller {
    private static final MarshallingInfo<String> ACTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionName").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionId").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionSummary").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionUrl").isBinary(false).build();
    private static final SourceRevisionMarshaller INSTANCE = new SourceRevisionMarshaller();

    private SourceRevisionMarshaller() {
    }

    public static SourceRevisionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceRevision sourceRevision, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceRevision, (String)"sourceRevision");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sourceRevision.actionName(), ACTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)sourceRevision.revisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall((Object)sourceRevision.revisionSummary(), REVISIONSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)sourceRevision.revisionUrl(), REVISIONURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

