/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ListWebhookItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListWebhookItemMarshaller {
    private static final MarshallingInfo<StructuredPojo> DEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("definition").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorMessage").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTTRIGGERED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastTriggered").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final ListWebhookItemMarshaller INSTANCE = new ListWebhookItemMarshaller();

    private ListWebhookItemMarshaller() {
    }

    public static ListWebhookItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListWebhookItem listWebhookItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)listWebhookItem, (String)"listWebhookItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listWebhookItem.definition(), DEFINITION_BINDING);
            protocolMarshaller.marshall((Object)listWebhookItem.url(), URL_BINDING);
            protocolMarshaller.marshall((Object)listWebhookItem.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)listWebhookItem.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)listWebhookItem.lastTriggered(), LASTTRIGGERED_BINDING);
            protocolMarshaller.marshall((Object)listWebhookItem.arn(), ARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

