/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ApprovalResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApprovalResultMarshaller {
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final ApprovalResultMarshaller INSTANCE = new ApprovalResultMarshaller();

    private ApprovalResultMarshaller() {
    }

    public static ApprovalResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApprovalResult approvalResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)approvalResult, (String)"approvalResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)approvalResult.summary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)approvalResult.statusAsString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

