/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.SourceRevisionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceRevision> {
    private final String actionName;
    private final String revisionId;
    private final String revisionSummary;
    private final String revisionUrl;

    private SourceRevision(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.revisionId = builder.revisionId;
        this.revisionSummary = builder.revisionSummary;
        this.revisionUrl = builder.revisionUrl;
    }

    public String actionName() {
        return this.actionName;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String revisionSummary() {
        return this.revisionSummary;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRevision)) {
            return false;
        }
        SourceRevision other = (SourceRevision)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.revisionSummary(), other.revisionSummary()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public String toString() {
        return ToString.builder((String)"SourceRevision").add("ActionName", (Object)this.actionName()).add("RevisionId", (Object)this.revisionId()).add("RevisionSummary", (Object)this.revisionSummary()).add("RevisionUrl", (Object)this.revisionUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "revisionSummary": {
                return Optional.ofNullable(clazz.cast(this.revisionSummary()));
            }
            case "revisionUrl": {
                return Optional.ofNullable(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private String revisionId;
        private String revisionSummary;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRevision model) {
            this.actionName(model.actionName);
            this.revisionId(model.revisionId);
            this.revisionSummary(model.revisionSummary);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        public SourceRevision build() {
            return new SourceRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceRevision> {
        public Builder actionName(String var1);

        public Builder revisionId(String var1);

        public Builder revisionSummary(String var1);

        public Builder revisionUrl(String var1);
    }
}

