/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.WebhookDefinition;
import software.amazon.awssdk.services.codepipeline.transform.ListWebhookItemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebhookItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ListWebhookItem> {
    private final WebhookDefinition definition;
    private final String url;
    private final String errorMessage;
    private final String errorCode;
    private final Instant lastTriggered;
    private final String arn;

    private ListWebhookItem(BuilderImpl builder) {
        this.definition = builder.definition;
        this.url = builder.url;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.lastTriggered = builder.lastTriggered;
        this.arn = builder.arn;
    }

    public WebhookDefinition definition() {
        return this.definition;
    }

    public String url() {
        return this.url;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public Instant lastTriggered() {
        return this.lastTriggered;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTriggered());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebhookItem)) {
            return false;
        }
        ListWebhookItem other = (ListWebhookItem)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.lastTriggered(), other.lastTriggered()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"ListWebhookItem").add("Definition", (Object)this.definition()).add("Url", (Object)this.url()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("LastTriggered", (Object)this.lastTriggered()).add("Arn", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "lastTriggered": {
                return Optional.ofNullable(clazz.cast(this.lastTriggered()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ListWebhookItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private WebhookDefinition definition;
        private String url;
        private String errorMessage;
        private String errorCode;
        private Instant lastTriggered;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebhookItem model) {
            this.definition(model.definition);
            this.url(model.url);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.lastTriggered(model.lastTriggered);
            this.arn(model.arn);
        }

        public final WebhookDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(WebhookDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(WebhookDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Instant getLastTriggered() {
            return this.lastTriggered;
        }

        @Override
        public final Builder lastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
            return this;
        }

        public final void setLastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public ListWebhookItem build() {
            return new ListWebhookItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListWebhookItem> {
        public Builder definition(WebhookDefinition var1);

        default public Builder definition(Consumer<WebhookDefinition.Builder> definition) {
            return this.definition((WebhookDefinition)((WebhookDefinition.Builder)WebhookDefinition.builder().applyMutation(definition)).build());
        }

        public Builder url(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder lastTriggered(Instant var1);

        public Builder arn(String var1);
    }
}

