/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ArtifactDetailsMarshaller {
    private static final MarshallingInfo<Integer> MINIMUMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXIMUMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximumCount").isBinary(false).build();
    private static final ArtifactDetailsMarshaller INSTANCE = new ArtifactDetailsMarshaller();

    private ArtifactDetailsMarshaller() {
    }

    public static ArtifactDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ArtifactDetails artifactDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)artifactDetails, (String)"artifactDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)artifactDetails.minimumCount(), MINIMUMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)artifactDetails.maximumCount(), MAXIMUMCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

