/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionState;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActionStateMarshaller {
    private static final MarshallingInfo<String> ACTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CURRENTREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentRevision").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LATESTEXECUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestExecution").isBinary(false).build();
    private static final MarshallingInfo<String> ENTITYURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityUrl").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionUrl").isBinary(false).build();
    private static final ActionStateMarshaller INSTANCE = new ActionStateMarshaller();

    private ActionStateMarshaller() {
    }

    public static ActionStateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionState actionState, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)actionState, (String)"actionState");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)actionState.actionName(), ACTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)actionState.currentRevision(), CURRENTREVISION_BINDING);
            protocolMarshaller.marshall((Object)actionState.latestExecution(), LATESTEXECUTION_BINDING);
            protocolMarshaller.marshall((Object)actionState.entityUrl(), ENTITYURL_BINDING);
            protocolMarshaller.marshall((Object)actionState.revisionUrl(), REVISIONURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

