/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActionConfigurationMarshaller {
    private static final MarshallingInfo<Map> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();
    private static final ActionConfigurationMarshaller INSTANCE = new ActionConfigurationMarshaller();

    private ActionConfigurationMarshaller() {
    }

    public static ActionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionConfiguration actionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)actionConfiguration, (String)"actionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(actionConfiguration.configuration(), CONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

