/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.S3ArtifactLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ArtifactLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, S3ArtifactLocation> {
    private final String bucketName;
    private final String objectKey;

    private S3ArtifactLocation(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.objectKey = builder.objectKey;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String objectKey() {
        return this.objectKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ArtifactLocation)) {
            return false;
        }
        S3ArtifactLocation other = (S3ArtifactLocation)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.objectKey(), other.objectKey());
    }

    public String toString() {
        return ToString.builder((String)"S3ArtifactLocation").add("BucketName", (Object)this.bucketName()).add("ObjectKey", (Object)this.objectKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "objectKey": {
                return Optional.ofNullable(clazz.cast(this.objectKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ArtifactLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String objectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ArtifactLocation model) {
            this.bucketName(model.bucketName);
            this.objectKey(model.objectKey);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        public S3ArtifactLocation build() {
            return new S3ArtifactLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ArtifactLocation> {
        public Builder bucketName(String var1);

        public Builder objectKey(String var1);
    }
}

