/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyListCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeSettings;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomActionTypeRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, CreateCustomActionTypeRequest> {
    private final String category;
    private final String provider;
    private final String version;
    private final ActionTypeSettings settings;
    private final List<ActionConfigurationProperty> configurationProperties;
    private final ArtifactDetails inputArtifactDetails;
    private final ArtifactDetails outputArtifactDetails;

    private CreateCustomActionTypeRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
        this.settings = builder.settings;
        this.configurationProperties = builder.configurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
    }

    public ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public String categoryAsString() {
        return this.category;
    }

    public String provider() {
        return this.provider;
    }

    public String version() {
        return this.version;
    }

    public ActionTypeSettings settings() {
        return this.settings;
    }

    public List<ActionConfigurationProperty> configurationProperties() {
        return this.configurationProperties;
    }

    public ArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public ArtifactDetails outputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifactDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomActionTypeRequest)) {
            return false;
        }
        CreateCustomActionTypeRequest other = (CreateCustomActionTypeRequest)((Object)obj);
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.configurationProperties(), other.configurationProperties()) && Objects.equals(this.inputArtifactDetails(), other.inputArtifactDetails()) && Objects.equals(this.outputArtifactDetails(), other.outputArtifactDetails());
    }

    public String toString() {
        return ToString.builder((String)"CreateCustomActionTypeRequest").add("Category", (Object)this.categoryAsString()).add("Provider", (Object)this.provider()).add("Version", (Object)this.version()).add("Settings", (Object)this.settings()).add("ConfigurationProperties", this.configurationProperties()).add("InputArtifactDetails", (Object)this.inputArtifactDetails()).add("OutputArtifactDetails", (Object)this.outputArtifactDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "configurationProperties": {
                return Optional.ofNullable(clazz.cast(this.configurationProperties()));
            }
            case "inputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.inputArtifactDetails()));
            }
            case "outputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.outputArtifactDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String category;
        private String provider;
        private String version;
        private ActionTypeSettings settings;
        private List<ActionConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();
        private ArtifactDetails inputArtifactDetails;
        private ArtifactDetails outputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomActionTypeRequest model) {
            super(model);
            this.category(model.category);
            this.provider(model.provider);
            this.version(model.version);
            this.settings(model.settings);
            this.configurationProperties(model.configurationProperties);
            this.inputArtifactDetails(model.inputArtifactDetails);
            this.outputArtifactDetails(model.outputArtifactDetails);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final Collection<ActionConfigurationProperty.Builder> getConfigurationProperties() {
            return this.configurationProperties != null ? (Collection)this.configurationProperties.stream().map(ActionConfigurationProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationProperties(Collection<ActionConfigurationProperty> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(ActionConfigurationProperty ... configurationProperties) {
            this.configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<ActionConfigurationProperty.Builder> ... configurationProperties) {
            this.configurationProperties(Stream.of(configurationProperties).map(c -> (ActionConfigurationProperty)((ActionConfigurationProperty.Builder)ActionConfigurationProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationProperties(Collection<ActionConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copyFromBuilder(configurationProperties);
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return this.outputArtifactDetails != null ? this.outputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomActionTypeRequest build() {
            return new CreateCustomActionTypeRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, CreateCustomActionTypeRequest> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder provider(String var1);

        public Builder version(String var1);

        public Builder settings(ActionTypeSettings var1);

        default public Builder settings(Consumer<ActionTypeSettings.Builder> settings) {
            return this.settings((ActionTypeSettings)((ActionTypeSettings.Builder)ActionTypeSettings.builder().applyMutation(settings)).build());
        }

        public Builder configurationProperties(Collection<ActionConfigurationProperty> var1);

        public Builder configurationProperties(ActionConfigurationProperty ... var1);

        public Builder configurationProperties(Consumer<ActionConfigurationProperty.Builder> ... var1);

        public Builder inputArtifactDetails(ArtifactDetails var1);

        default public Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return this.inputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(inputArtifactDetails)).build());
        }

        public Builder outputArtifactDetails(ArtifactDetails var1);

        default public Builder outputArtifactDetails(Consumer<ArtifactDetails.Builder> outputArtifactDetails) {
            return this.outputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(outputArtifactDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

