/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ExecutionDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExecutionDetailsMarshaller {
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionId").isBinary(false).build();
    private static final MarshallingInfo<Integer> PERCENTCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentComplete").isBinary(false).build();
    private static final ExecutionDetailsMarshaller INSTANCE = new ExecutionDetailsMarshaller();

    private ExecutionDetailsMarshaller() {
    }

    public static ExecutionDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExecutionDetails executionDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)executionDetails, (String)"executionDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)executionDetails.summary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)executionDetails.externalExecutionId(), EXTERNALEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)executionDetails.percentComplete(), PERCENTCOMPLETE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

