/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.PipelineSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineSummary> {
    private final String name;
    private final Integer version;
    private final Instant created;
    private final Instant updated;

    private PipelineSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public String name() {
        return this.name;
    }

    public Integer version() {
        return this.version;
    }

    public Instant created() {
        return this.created;
    }

    public Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.updated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.updated(), other.updated());
    }

    public String toString() {
        return ToString.builder((String)"PipelineSummary").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Created", (Object)this.created()).add("Updated", (Object)this.updated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "updated": {
                return Optional.of(clazz.cast(this.updated()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer version;
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            this.name(model.name);
            this.version(model.version);
            this.created(model.created);
            this.updated(model.updated);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public PipelineSummary build() {
            return new PipelineSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineSummary> {
        public Builder name(String var1);

        public Builder version(Integer var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

