/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration;
import software.amazon.awssdk.services.codepipeline.model.PipelineMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPipelineResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, GetPipelineResponse> {
    private final PipelineDeclaration pipeline;
    private final PipelineMetadata metadata;

    private GetPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.metadata = builder.metadata;
    }

    public PipelineDeclaration pipeline() {
        return this.pipeline;
    }

    public PipelineMetadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineResponse)) {
            return false;
        }
        GetPipelineResponse other = (GetPipelineResponse)((Object)obj);
        return Objects.equals(this.pipeline(), other.pipeline()) && Objects.equals(this.metadata(), other.metadata());
    }

    public String toString() {
        return ToString.builder((String)"GetPipelineResponse").add("Pipeline", (Object)this.pipeline()).add("Metadata", (Object)this.metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipeline": {
                return Optional.of(clazz.cast(this.pipeline()));
            }
            case "metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private PipelineDeclaration pipeline;
        private PipelineMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineResponse model) {
            super(model);
            this.pipeline(model.pipeline);
            this.metadata(model.metadata);
        }

        public final PipelineDeclaration.Builder getPipeline() {
            return this.pipeline != null ? this.pipeline.toBuilder() : null;
        }

        @Override
        public final Builder pipeline(PipelineDeclaration pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final void setPipeline(PipelineDeclaration.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        public final PipelineMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(PipelineMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(PipelineMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public GetPipelineResponse build() {
            return new GetPipelineResponse(this);
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    CopyableBuilder<Builder, GetPipelineResponse> {
        public Builder pipeline(PipelineDeclaration var1);

        default public Builder pipeline(Consumer<PipelineDeclaration.Builder> pipeline) {
            return this.pipeline((PipelineDeclaration)((PipelineDeclaration.Builder)PipelineDeclaration.builder().apply(pipeline)).build());
        }

        public Builder metadata(PipelineMetadata var1);

        default public Builder metadata(Consumer<PipelineMetadata.Builder> metadata) {
            return this.metadata((PipelineMetadata)((PipelineMetadata.Builder)PipelineMetadata.builder().apply(metadata)).build());
        }
    }
}

