/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType;
import software.amazon.awssdk.services.codepipeline.model.EncryptionKey;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactStoreMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArtifactStore
implements StructuredPojo,
ToCopyableBuilder<Builder, ArtifactStore> {
    private final String type;
    private final String location;
    private final EncryptionKey encryptionKey;

    private ArtifactStore(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.encryptionKey = builder.encryptionKey;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public EncryptionKey encryptionKey() {
        return this.encryptionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.encryptionKey() == null ? 0 : this.encryptionKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactStore)) {
            return false;
        }
        ArtifactStore other = (ArtifactStore)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.encryptionKey() == null ^ this.encryptionKey() == null) {
            return false;
        }
        return other.encryptionKey() == null || other.encryptionKey().equals(this.encryptionKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.encryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.encryptionKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactStoreMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private EncryptionKey encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactStore model) {
            this.setType(model.type);
            this.setLocation(model.location);
            this.setEncryptionKey(model.encryptionKey);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactStoreType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ArtifactStoreType type) {
            this.type(type.toString());
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final EncryptionKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public ArtifactStore build() {
            return new ArtifactStore(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArtifactStore> {
        public Builder type(String var1);

        public Builder type(ArtifactStoreType var1);

        public Builder location(String var1);

        public Builder encryptionKey(EncryptionKey var1);
    }
}

